/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jwt.JWTParser;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.IOException;
import java.text.ParseException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetRequestObjectToResponseContext
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetRequestObjectToResponseContext.class);
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    public void setHttpClient(@Nonnull HttpClient client) {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.httpClientSecurityParameters = params;
    }

    @Nonnull
    private HttpClientContext buildHttpContext(@Nonnull HttpUriRequest request) {
        HttpClientContext clientContext = HttpClientContext.create();
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)false);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpUriRequest)request);
        return clientContext;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull((Object)this.httpClient, (String)"Httpclient cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (!this.getAuthenticationRequest().specifiesRequestObject()) {
            this.log.debug("{} No request_uri or request by value, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        if (this.getAuthenticationRequest().getRequestObject() != null && this.getAuthenticationRequest().getRequestURI() != null) {
            this.log.error("{} request_uri and request object cannot be both set", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestObjectAndUri");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Set allowedURIs;
        OIDCClientMetadata metadata;
        if (this.getAuthenticationRequest().getRequestObject() != null) {
            this.getOidcResponseContext().setRequestObject(this.getAuthenticationRequest().getRequestObject());
            this.log.debug("{} Request object {} by value stored to oidc response context", (Object)this.getLogPrefix(), (Object)this.getOidcResponseContext().getRequestObject().serialize());
            return;
        }
        boolean authorized = false;
        if (this.getMetadataContext() != null && this.getMetadataContext().getClientInformation() != null && (metadata = this.getMetadataContext().getClientInformation().getOIDCMetadata()) != null && (allowedURIs = metadata.getRequestObjectURIs()) != null) {
            authorized = allowedURIs.contains(this.getAuthenticationRequest().getRequestURI());
        }
        if (!authorized) {
            this.log.error("{} Unregistered request URI blocked: {}", (Object)this.getLogPrefix(), (Object)this.getAuthenticationRequest().getRequestURI());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestUri");
            return;
        }
        HttpGet httpRequest = new HttpGet(this.getAuthenticationRequest().getRequestURI());
        HttpClientContext httpContext = this.buildHttpContext((HttpUriRequest)httpRequest);
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)httpContext, (String)httpRequest.getURI().getScheme());
            if (response.getStatusLine().getStatusCode() == 200) {
                String requestObject = EntityUtils.toString((HttpEntity)response.getEntity());
                try {
                    this.getOidcResponseContext().setRequestObject(JWTParser.parse((String)requestObject));
                    this.log.debug("{} Request object {} by reference stored to oidc response context", (Object)this.getLogPrefix(), (Object)this.getOidcResponseContext().getRequestObject().serialize());
                    return;
                }
                catch (ParseException e) {
                    this.log.error("{} Unable to parse request object from request_uri, {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestUri");
                    return;
                }
            }
            this.log.error("{} Unable to get request object from request_uri, HTTP status {}", (Object)this.getLogPrefix(), (Object)response.getStatusLine().getStatusCode());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestUri");
            return;
        }
        catch (IOException e) {
            this.log.error("{} Unable to get request object from request_uri, {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestUri");
            return;
        }
    }
}

