/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.time.Instant;
import java.util.Date;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildClientInformation
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildClientInformation.class);
    @Nonnull
    private Function<MessageContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy = new ChildContextLookup(OIDCClientRegistrationResponseContext.class);
    private MessageContext messageContext;
    private OIDCClientRegistrationResponseContext oidcResponseContext;

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<MessageContext, OIDCClientRegistrationResponseContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.messageContext = profileRequestContext.getOutboundMessageContext();
        if (this.messageContext == null) {
            this.log.error("{} No message context found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.oidcResponseContext = this.oidcResponseContextLookupStrategy.apply(this.messageContext);
        if (this.oidcResponseContext == null) {
            this.log.error("{} No OIDC response context found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Secret clientSecret;
        boolean secretNeeded;
        String id = this.oidcResponseContext.getClientId();
        if (StringSupport.trimOrNull((String)id) == null) {
            this.log.error("{} No client ID in the OIDC response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        ClientID clientId = new ClientID(id);
        OIDCClientMetadata metadata = this.oidcResponseContext.getClientMetadata();
        if (metadata == null) {
            this.log.error("{} No client metadata in the OIDC response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        ClientAuthenticationMethod tokenAuthMethod = metadata.getTokenEndpointAuthMethod();
        boolean bl = secretNeeded = tokenAuthMethod == null || tokenAuthMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) || tokenAuthMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) || tokenAuthMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_POST);
        if (secretNeeded) {
            if (StringSupport.trimOrNull((String)this.oidcResponseContext.getClientSecret()) == null) {
                this.log.error("{} No required client secret in the OIDC response context", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
                return;
            }
            Instant secretExpiresAt = this.oidcResponseContext.getClientSecretExpiresAt();
            if (secretExpiresAt != null) {
                this.log.warn("{} client secret expiration time {} is ignored", (Object)this.getLogPrefix(), (Object)secretExpiresAt);
            }
            clientSecret = new Secret(this.oidcResponseContext.getClientSecret());
        } else {
            clientSecret = null;
        }
        OIDCClientInformation clientInformation = new OIDCClientInformation(clientId, new Date(), metadata, clientSecret);
        OIDCClientInformationResponse response = new OIDCClientInformationResponse(clientInformation, true);
        this.messageContext.setMessage((Object)response);
        this.log.info("{} Client information successfully added to the outbound context", (Object)this.getLogPrefix());
    }
}

