/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.AudienceRestrictionsLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.IDTokenLifetimeLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddIDTokenShell
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddIDTokenShell.class);
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new ResponderIdLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> audienceRestrictionsLookupStrategy = new AudienceRestrictionsLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> idTokenLifetimeLookupStrategy = new IDTokenLifetimeLookupFunction();
    @Nullable
    private String issuerId;
    @Nullable
    private RelyingPartyContext rpCtx;
    @Nullable
    private Collection<String> audiences;
    @Nullable
    private Duration lifetime;

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    public void setAudienceRestrictionsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.audienceRestrictionsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Audience restriction lookup strategy cannot be null");
    }

    public void setIDTokenLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ID token lifetime lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuerId == null) {
            this.log.warn("{} No issuer returned for ID token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.audiences = this.audienceRestrictionsLookupStrategy.apply(profileRequestContext);
        if (this.audiences == null || this.audiences.isEmpty()) {
            this.log.warn("{} No audiences returned for ID token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.lifetime = this.idTokenLifetimeLookupStrategy.apply(profileRequestContext);
        if (this.lifetime == null) {
            this.log.warn("{} No lifetime supplied for ID token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ArrayList<Audience> aud = new ArrayList<Audience>();
        for (String audience : this.audiences) {
            aud.add(new Audience(audience));
        }
        Date exp = Date.from(Instant.now().plus(this.lifetime));
        IDTokenClaimsSet idToken = new IDTokenClaimsSet(new Issuer(this.issuerId), new Subject(this.getOidcResponseContext().getSubject()), aud, exp, new Date());
        this.log.debug("{} Setting ID token shell to response context {}", (Object)this.getLogPrefix(), (Object)idToken.toJSONObject().toJSONString());
        this.getOidcResponseContext().setIDToken(idToken);
    }
}

