/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import java.text.ParseException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.context.OAuth2TokenMgmtResponseContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormOutboundIntrospectionResponseMessage
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormOutboundIntrospectionResponseMessage.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OAuth2TokenMgmtResponseContext ctx = (OAuth2TokenMgmtResponseContext)profileRequestContext.getOutboundMessageContext().getSubcontext(OAuth2TokenMgmtResponseContext.class);
        if (ctx == null || ctx.getTokenClaimsSet() == null) {
            this.log.debug("{} Introspection of token failed, token was not valid", (Object)this.getLogPrefix());
            profileRequestContext.getOutboundMessageContext().setMessage((Object)new TokenIntrospectionSuccessResponse.Builder(false).build());
            return;
        }
        JWTClaimsSet tokenClaimsSet = ctx.getTokenClaimsSet();
        try {
            String clientID = tokenClaimsSet.getStringClaim("client_id");
            if (clientID == null) {
                clientID = tokenClaimsSet.getStringClaim("clid");
            }
            TokenIntrospectionSuccessResponse.Builder builder = new TokenIntrospectionSuccessResponse.Builder(true).clientID(new ClientID(clientID)).tokenType(AccessTokenType.BEARER).expirationTime(tokenClaimsSet.getExpirationTime()).issueTime(tokenClaimsSet.getIssueTime()).subject(new Subject(tokenClaimsSet.getSubject())).issuer(new Issuer(tokenClaimsSet.getIssuer()));
            String claim = tokenClaimsSet.getStringClaim("prncpl");
            if (claim != null) {
                builder.username(claim);
            }
            if ((claim = tokenClaimsSet.getStringClaim("scope")) != null) {
                builder.scope(Scope.parse((String)claim));
            }
            if (!tokenClaimsSet.getAudience().isEmpty()) {
                builder.audience(tokenClaimsSet.getAudience().stream().map(Audience::new).collect(Collectors.toUnmodifiableList()));
            }
            profileRequestContext.getOutboundMessageContext().setMessage((Object)builder.build());
        }
        catch (ParseException e) {
            this.log.error("{} Failure extracting claims for response", (Object)this.getLogPrefix(), (Object)e);
            profileRequestContext.getOutboundMessageContext().setMessage((Object)new TokenIntrospectionSuccessResponse.Builder(false).build());
        }
    }
}

