/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jose.Payload;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.AccessTokenContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractEncryptTokenAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptAccessToken
extends AbstractEncryptTokenAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(EncryptAccessToken.class);
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenContext> accessTokenContextLookupStrategy = new ChildContextLookup(AccessTokenContext.class).compose(new ChildContextLookup(OIDCAuthenticationResponseContext.class).compose((Function)new OutboundMessageContextLookup()));
    @Nullable
    private AccessTokenContext tokenCtx;

    public void setAccessTokenContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.accessTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AccessTokenContext lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.tokenCtx = this.accessTokenContextLookupStrategy.apply(profileRequestContext);
        if (this.tokenCtx == null) {
            this.log.error("{} AccessTokenContext is missing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    @Override
    protected Payload getPayload(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.tokenCtx.getJWT() instanceof SignedJWT) {
            return new Payload((SignedJWT)this.tokenCtx.getJWT());
        }
        if (this.tokenCtx.getJWT() instanceof PlainJWT) {
            try {
                return new Payload(this.tokenCtx.getJWT().getJWTClaimsSet().getClaims());
            }
            catch (ParseException e) {
                this.log.error("{} Unable to convert plaintext JWT to claims set", (Object)this.getLogPrefix(), (Object)e);
            }
        }
        return null;
    }

    @Override
    protected void setProcessedToken(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull EncryptedJWT token) {
        this.tokenCtx.setJWT((JWT)token);
    }
}

