/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.AccessTokenContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestClientIDLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.oidc.profile.config.logic.AttributeConsentFlowEnabledPredicate;
import net.shibboleth.oidc.profile.config.navigate.AccessTokenClaimsSetManipulationStrategyLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.AccessTokenLifetimeLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.AccessTokenTypeLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildAccessToken
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BuildAccessToken.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, ClientID> clientIDLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> accessTokenTypeLookupStrategy = new AccessTokenTypeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> accessTokenLifetimeLookupStrategy = new AccessTokenLifetimeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> consentContextLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> consentEnabledPredicate;
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenContext> accessTokenContextCreationStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> tokenClaimsSetManipulationStrategyLookupStrategy;
    @Nullable
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    @Nullable
    private TokenClaimsSet tokenClaimsSet;
    @Nullable
    private AuthenticationRequest authenticationRequest;
    @Nullable
    private SubjectContext subjectCtx;
    private boolean jwtTokenType;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private AccessTokenContext accessTokenCtx;

    public BuildAccessToken() {
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
        this.clientIDLookupStrategy = FunctionSupport.compose((Function)new TokenRequestClientIDLookupFunction(), (Function)new InboundMessageContextLookup());
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
        this.tokenClaimsContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        this.consentContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseConsentContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        this.consentEnabledPredicate = new AttributeConsentFlowEnabledPredicate();
        this.accessTokenContextCreationStrategy = new ChildContextLookup(AccessTokenContext.class, true).compose(new ChildContextLookup(OIDCAuthenticationResponseContext.class).compose((Function)new OutboundMessageContextLookup()));
        this.tokenClaimsSetManipulationStrategyLookupStrategy = new AccessTokenClaimsSetManipulationStrategyLookupFunction();
    }

    public void setDataSealer(@Nullable DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = sealer;
    }

    public void setAccessTokenTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.accessTokenTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Access token type lookup strategy cannot be null");
    }

    public void setAccessTokenLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.accessTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Access token lifetime lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier generation strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public void setClientIDLookupStrategy(@Nonnull Function<ProfileRequestContext, ClientID> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientID lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContextt lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseConsentContext lookup strategy cannot be null");
    }

    public void setConsentEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentEnabledPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"predicate used to check if consent is enabled cannot be null");
    }

    public void setAccessTokenContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.accessTokenContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AccessTokenContext creation strategy cannot be null");
    }

    public void setTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Manipulation strategy lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        String tokenType = this.accessTokenTypeLookupStrategy.apply(profileRequestContext);
        boolean bl = this.jwtTokenType = tokenType != null && "JWT".equals(tokenType);
        if (!this.jwtTokenType && this.dataSealer == null) {
            this.log.error("{} DataSealer required for opaque access tokens", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
            return false;
        }
        this.tokenClaimsSet = this.getOidcResponseContext().getAuthorizationGrantClaimsSet();
        if (this.tokenClaimsSet != null && !(this.tokenClaimsSet instanceof RefreshTokenClaimsSet) && !(this.tokenClaimsSet instanceof AuthorizeCodeClaimsSet)) {
            this.log.error("{} Authorization grant is of unknown type: {}", (Object)this.getLogPrefix(), (Object)this.tokenClaimsSet.getClass().getName());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.error("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.tokenClaimsSet == null) {
            this.subjectCtx = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class);
            if (this.subjectCtx == null) {
                this.log.error("{} No subject context", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return false;
            }
            if (profileRequestContext.getInboundMessageContext() != null && profileRequestContext.getInboundMessageContext().getMessage() instanceof AuthenticationRequest) {
                this.authenticationRequest = (AuthenticationRequest)profileRequestContext.getInboundMessageContext().getMessage();
            }
        }
        this.accessTokenCtx = this.accessTokenContextCreationStrategy.apply(profileRequestContext);
        if (this.accessTokenCtx == null) {
            this.log.error("{} Unable to create AccessTokenContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Duration lifetime = this.accessTokenLifetimeLookupStrategy.apply(profileRequestContext);
        if (lifetime == null) {
            this.log.error("{} No lifetime supplied for access token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.accessTokenCtx.setLifetime(lifetime);
        this.manipulationStrategy = this.tokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AccessTokenClaimsSet.Builder builder;
        OIDCAuthenticationResponseContext responseCtx;
        String issuer = this.issuerLookupStrategy.apply(profileRequestContext);
        ClientID clientID = this.clientIDLookupStrategy.apply(profileRequestContext);
        if (issuer == null || clientID == null) {
            this.log.error("{} Unable to determine issuer or clientID, failing request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return;
        }
        ClaimsSet claims = null;
        ClaimsSet claimsUI = null;
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext);
        if (tokenClaimsCtx != null) {
            claims = tokenClaimsCtx.getClaims();
            claimsUI = tokenClaimsCtx.getUserinfoClaims();
        }
        Scope scope = (responseCtx = this.getOidcResponseContext()).getScope() != null ? responseCtx.getScope() : new Scope();
        this.log.debug("{} Building access token with scope: {}", (Object)this.getLogPrefix(), (Object)scope);
        boolean oidc = scope.contains("openid");
        if (oidc) {
            responseCtx.getAudience().add(issuer);
        }
        this.log.debug("{} Building access token with audience: {}", (Object)this.getLogPrefix(), (Object)responseCtx.getAudience());
        Instant now = Instant.now();
        Instant dateExp = now.plus(this.accessTokenCtx.getLifetime());
        if (this.tokenClaimsSet != null) {
            builder = new AccessTokenClaimsSet.Builder(this.tokenClaimsSet, scope, (ClaimsSet)(oidc ? claims : null), (ClaimsSet)(oidc ? claimsUI : null), Instant.now(), dateExp);
            builder.setAudience((Collection)responseCtx.getAudience());
            builder.setJWTID(this.idGenerator);
            if (StringSupport.trimOrNull((String)this.tokenClaimsSet.getRootTokenIdentifier()) == null) {
                builder.setRootTokenIdentifier(this.tokenClaimsSet.getID());
            }
        } else {
            OIDCAuthenticationResponseConsentContext consentCtx = this.consentContextLookupStrategy.apply(profileRequestContext);
            JSONArray consented = consentCtx != null ? consentCtx.getConsentedAttributes() : null;
            builder = (AccessTokenClaimsSet.Builder)new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(clientID).setIssuer(issuer).setPrincipal(this.subjectCtx.getPrincipalName()).setSubject(responseCtx.getSubject()).setIssuedAt(now).setExpiresAt(dateExp).setACR(responseCtx.getAcr()).setAuthenticationTime(responseCtx.getAuthTime()).setScope(scope).setAudience((Collection)responseCtx.getAudience()).setDlClaims(claims).setDlClaimsUI(claimsUI).setConsentedClaims((List)consented).setConsentEnabled(Boolean.valueOf(this.consentEnabledPredicate.test(profileRequestContext)));
            if (this.authenticationRequest != null) {
                builder.setNonce(this.authenticationRequest.getNonce()).setClaimsRequest(this.authenticationRequest.getOIDCClaims());
            }
        }
        if (this.jwtTokenType && responseCtx.getAccessTokenClaimSet() != null) {
            builder.setCustomClaims(responseCtx.getAccessTokenClaimSet().toJSONObject());
        }
        AccessTokenClaimsSet claimsSet = builder.build();
        if (this.manipulationStrategy != null) {
            this.log.debug("{} Manipulation strategy has been set, applying it to the claims set {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, claimsSet.getClaimsSet().toJSONObject());
            if (result == null) {
                this.log.debug("{} Manipulation strategy returned null, leaving token claims set untouched.", (Object)this.getLogPrefix());
            } else {
                this.log.debug("{} Applying the manipulated claims into the token claims set", (Object)this.getLogPrefix());
                try {
                    claimsSet.setClaimsSet(JWTClaimsSet.parse(result));
                }
                catch (ParseException e) {
                    this.log.error("{} The resulted claims set could not be transformed into ", (Object)this.getLogPrefix(), (Object)e);
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                    return;
                }
            }
        } else {
            this.log.debug("{} No manipulation strategy configured", (Object)this.getLogPrefix());
        }
        try {
            if (this.jwtTokenType) {
                this.accessTokenCtx.setJWT((JWT)new PlainJWT(this.sealClaims(claimsSet.getClaimsSet())));
                this.log.debug("{} Claims stored to JWT access token: {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            } else {
                this.accessTokenCtx.setOpaque(claimsSet.serialize(this.dataSealer));
                this.log.debug("{} Claims converted to opaque access token: {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            }
        }
        catch (ParseException | DataSealerException e) {
            this.log.error("{} Access Token wrapping failed: {}", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
        }
    }

    @Nonnull
    private JWTClaimsSet sealClaims(@Nonnull JWTClaimsSet claims) throws DataSealerException, ParseException {
        Map map = claims.toJSONObject();
        HashMap toSeal = new HashMap();
        if (map.containsKey("type")) {
            toSeal.put("type", map.remove("type"));
        }
        if (map.containsKey("prncpl")) {
            toSeal.put("prncpl", map.remove("prncpl"));
        }
        if (map.containsKey("dl_claims")) {
            toSeal.put("dl_claims", map.remove("dl_claims"));
        }
        if (map.containsKey("dl_claims_ui")) {
            toSeal.put("dl_claims_ui", map.remove("dl_claims_ui"));
        }
        if (map.containsKey("cnsntd_claims")) {
            toSeal.put("cnsntd_claims", map.remove("cnsntd_claims"));
        }
        if (map.containsKey("cnsnt")) {
            toSeal.put("cnsnt", map.remove("cnsnt"));
        }
        if (map.containsKey("cc")) {
            toSeal.put("cc", map.remove("cc"));
        }
        if (map.containsKey("nonce")) {
            toSeal.put("nonce", map.remove("nonce"));
        }
        if (toSeal.isEmpty()) {
            return claims;
        }
        String sealed = this.dataSealer.wrap(JWTClaimsSet.parse(toSeal).toString());
        map.put("for_op", sealed);
        return JWTClaimsSet.parse((Map)map);
    }
}

