/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientRegistrationRequestDecoder
extends BaseOAuth2RequestDecoder<OIDCClientRegistrationRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCClientRegistrationRequestDecoder.class);

    @Override
    protected OIDCClientRegistrationRequest parseMessage() throws MessageDecodingException {
        try {
            HTTPRequest httpRequest = ServletUtils.createHTTPRequest((HttpServletRequest)this.getHttpServletRequest());
            this.getProtocolMessageLog().trace("Inbound request {}", (Object)RequestUtil.toString(httpRequest));
            JSONObject requestJson = httpRequest.getQueryAsJSONObject();
            if (requestJson.containsKey((Object)"scope")) {
                this.log.debug("Removed 'scope'");
                requestJson.remove((Object)"scope");
                httpRequest.setQuery(requestJson.toJSONString());
            }
            this.log.trace("JSON object: {}", (Object)httpRequest.getQueryAsJSONObject().toJSONString());
            return OIDCClientRegistrationRequest.parse((HTTPRequest)httpRequest);
        }
        catch (IOException e) {
            this.log.error("Could not create HTTP request from the request", (Throwable)e);
            throw new MessageDecodingException((Exception)e);
        }
        catch (ParseException e) {
            this.log.error("Unable to decode oidc request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)((Object)e));
        }
    }

    @Override
    protected String getMessageToLog(@Nullable OIDCClientRegistrationRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("accessToken", (Object)RequestUtil.getAccessTokenLog(message.getAccessToken())).add("clientMetadata", (Object)message.getClientMetadata()).add("endpointURI", (Object)message.getEndpointURI()).add("oidcClientMetadata", (Object)message.getOIDCClientMetadata()).add("softwareStatement", message.getSoftwareStatement() == null ? null : message.getSoftwareStatement().serialize()).toString();
    }
}

