/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;

public final class AuthorizeCodeClaimsSet
extends TokenClaimsSet {
    @Nonnull
    @NotEmpty
    public static final String VALUE_TYPE_AC = "ac";

    private AuthorizeCodeClaimsSet(JWTClaimsSet authzCodeClaimsSet) {
        super(authzCodeClaimsSet);
    }

    public static AuthorizeCodeClaimsSet parse(String authorizeCodeClaimsSet) throws ParseException {
        JWTClaimsSet acClaimsSet = JWTClaimsSet.parse((String)authorizeCodeClaimsSet);
        AuthorizeCodeClaimsSet.verifyParsedClaims(VALUE_TYPE_AC, acClaimsSet);
        return new AuthorizeCodeClaimsSet(acClaimsSet);
    }

    public static AuthorizeCodeClaimsSet parse(@Nonnull String wrappedAuthCode, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        return AuthorizeCodeClaimsSet.parse(dataSealer.unwrap(wrappedAuthCode));
    }

    public static class Builder
    extends TokenClaimsSet.Builder<AuthorizeCodeClaimsSet> {
        public Builder() {
        }

        @Deprecated(since="3.1.0", forRemoval=true)
        public Builder(@Nonnull IdentifierGenerationStrategy idGenerator, @Nonnull ClientID clientID, @Nonnull String issuer, @Nonnull String userPrincipal, @Nonnull String subject, @Nonnull Instant issuedAt, @Nonnull Instant expiresAt, @Nonnull Instant authenticationTime, @Nonnull URI redirectURI, @Nonnull Scope scope) {
            this.setJWTID(idGenerator);
            this.setClientID(clientID);
            this.setIssuer(issuer);
            this.setPrincipal(userPrincipal);
            this.setSubject(subject);
            this.setIssuedAt(issuedAt);
            this.setExpiresAt(expiresAt);
            this.setAuthenticationTime(authenticationTime);
            this.setRedirectURI(redirectURI);
            this.setScope(scope);
        }

        @Override
        public AuthorizeCodeClaimsSet build() {
            return new AuthorizeCodeClaimsSet(this.buildJWTClaimsSet(AuthorizeCodeClaimsSet.VALUE_TYPE_AC));
        }
    }
}

