/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;

public final class AccessTokenClaimsSet
extends TokenClaimsSet {
    @Nonnull
    @NotEmpty
    protected static final String VALUE_TYPE_AT = "at";

    @Deprecated(since="3.1.0", forRemoval=true)
    public AccessTokenClaimsSet(@Nonnull TokenClaimsSet tokenClaimsSet, @Nonnull Scope scope, @Nullable ClaimsSet dlClaims, @Nullable ClaimsSet dlClaimsUI, @Nonnull Instant iat, @Nonnull Instant exp) {
        Builder builder = new Builder(tokenClaimsSet, scope, dlClaims, dlClaimsUI, iat, exp);
        this.setClaimsSet(builder.buildJWTClaimsSet(VALUE_TYPE_AT));
    }

    protected AccessTokenClaimsSet(@Nonnull JWTClaimsSet accessTokenClaimsSet) {
        super(accessTokenClaimsSet);
    }

    @Nonnull
    public static AccessTokenClaimsSet parse(@Nonnull @NotEmpty String accessTokenClaimsSet) throws ParseException {
        JWTClaimsSet atClaimsSet = JWTClaimsSet.parse((String)accessTokenClaimsSet);
        AccessTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_AT, atClaimsSet);
        return new AccessTokenClaimsSet(atClaimsSet);
    }

    @Nonnull
    public static AccessTokenClaimsSet parse(@Nonnull @NotEmpty String wrappedAccessToken, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        return AccessTokenClaimsSet.parse(dataSealer.unwrap(wrappedAccessToken));
    }

    @Nonnull
    public static AccessTokenClaimsSet parse(@Nonnull @NotEmpty JWT jwtAccessToken, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        JWTClaimsSet claims = jwtAccessToken.getJWTClaimsSet();
        if (claims.getClaim("for_op") == null) {
            AccessTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_AT, claims);
            return new AccessTokenClaimsSet(claims);
        }
        Map map = claims.toJSONObject();
        JWTClaimsSet unsealed = JWTClaimsSet.parse((String)dataSealer.unwrap(claims.getStringClaim("for_op")));
        map.remove("for_op");
        for (Map.Entry claim : unsealed.getClaims().entrySet()) {
            map.put((String)claim.getKey(), claim.getValue());
        }
        claims = JWTClaimsSet.parse((Map)map);
        AccessTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_AT, claims);
        return new AccessTokenClaimsSet(claims);
    }

    public static final class Builder
    extends TokenClaimsSet.Builder<AccessTokenClaimsSet> {
        public Builder() {
        }

        @Deprecated(since="3.1.0", forRemoval=true)
        public Builder(@Nonnull IdentifierGenerationStrategy idGenerator, @Nonnull ClientID clientID, @Nonnull String issuer, @Nonnull String userPrincipal, @Nonnull String subject, @Nonnull Instant issuedAt, @Nonnull Instant expiresAt, @Nonnull Instant authenticationTime, @Nonnull URI redirectURI, @Nonnull Scope scope) {
            this.setJWTID(idGenerator);
            this.setClientID(clientID);
            this.setIssuer(issuer);
            this.setPrincipal(userPrincipal);
            this.setSubject(subject);
            this.setIssuedAt(issuedAt);
            this.setExpiresAt(expiresAt);
            this.setAuthenticationTime(authenticationTime);
            this.setScope(scope);
        }

        public Builder(@Nonnull TokenClaimsSet existing, @Nonnull Scope scope, @Nullable ClaimsSet dlClaims, @Nullable ClaimsSet dlClaimsUI, @Nonnull Instant iat, @Nonnull Instant exp) {
            this(existing);
            this.setScope(scope);
            this.setDlClaims(dlClaims);
            this.setDlClaimsUI(dlClaimsUI);
            this.setIssuedAt(iat);
            this.setExpiresAt(exp);
        }

        private Builder(@Nonnull TokenClaimsSet existing) {
            this.setJWTID(existing.getID());
            this.setClientID(existing.getClientID());
            this.setIssuer(existing.getClaimsSet().getIssuer());
            this.setPrincipal(existing.getPrincipal());
            this.setSubject(existing.getClaimsSet().getSubject());
            this.setACR(existing.getACR() == null ? null : new ACR(existing.getACR()));
            this.setNonce(existing.getNonce());
            this.setNotBefore(existing.getNotBefore());
            this.setAuthenticationTime(existing.getAuthenticationTime());
            this.setAudience(existing.getAudience());
            this.setClaimsRequest(existing.getClaimsRequest());
            this.setConsentedClaims(existing.getConsentedClaims());
            this.setConsentEnabled(existing.isConsentEnabled());
            this.setRootTokenIdentifier(existing.getRootTokenIdentifier());
        }

        @Override
        public AccessTokenClaimsSet build() {
            return new AccessTokenClaimsSet(this.buildJWTClaimsSet(AccessTokenClaimsSet.VALUE_TYPE_AT));
        }
    }
}

