/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import java.net.URI;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectorIdentifierLookupFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SectorIdentifierLookupFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadata lookup strategy cannot be null");
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        OIDCMetadataContext ctx = this.oidcMetadataContextLookupStrategy.apply(input);
        if (ctx == null || ctx.getClientInformation() == null || ctx.getClientInformation().getOIDCMetadata() == null) {
            this.log.warn("OIDC metadata not available, no sector identifier can be resolved");
            return null;
        }
        if (ctx.getClientInformation().getOIDCMetadata().getSectorIDURI() != null) {
            String sectorIdentifier = ctx.getClientInformation().getOIDCMetadata().getSectorIDURI().getHost();
            this.log.debug("Sector identifier resolved by registered sector uri {}", (Object)sectorIdentifier);
            return sectorIdentifier;
        }
        if (ctx.getClientInformation().getOIDCMetadata().getRedirectionURIs() == null) {
            this.log.warn("Redirection uri not available, unable to determine sector identifier");
            return null;
        }
        Set hosts = ctx.getClientInformation().getOIDCMetadata().getRedirectionURIs().stream().map(URI::getHost).collect(Collectors.toSet());
        if (hosts.size() > 1) {
            this.log.warn("Multiple hosts found from the redirection uris but no registered sector uri");
            return null;
        }
        String sectorIdentifier = (String)hosts.stream().findFirst().get();
        this.log.debug("Sector identifier by single host from redirect uris: {}", (Object)sectorIdentifier);
        return sectorIdentifier;
    }
}

