/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestLoginHintLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestNonceLookupFunction
extends AbstractAuthenticationRequestLookupFunction<Nonce> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestLoginHintLookupFunction.class);

    @Override
    protected Nonce doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("nonce") != null) {
                Object nonce = this.getRequestObject().getJWTClaimsSet().getClaim("nonce");
                if (nonce instanceof String) {
                    return new Nonce((String)nonce);
                }
                this.log.error("nonce claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse nonce from request object nonce value");
            return null;
        }
        if (req.getNonce() != null) {
            return new Nonce(req.getNonce().getValue());
        }
        return null;
    }
}

