/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestCodeChallengeLookupFunction
extends AbstractAuthenticationRequestLookupFunction<String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestCodeChallengeLookupFunction.class);

    @Override
    @Nullable
    protected String doLookup(@Nonnull AuthenticationRequest req) {
        try {
            if (this.getRequestObject() != null && this.getRequestObject().getJWTClaimsSet().getClaim("code_challenge") != null) {
                Object codeChallenge = this.getRequestObject().getJWTClaimsSet().getClaim("code_challenge");
                if (codeChallenge instanceof String) {
                    return (String)codeChallenge;
                }
                this.log.error("code_challenge claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse code challenge from request object code_challenge value");
            return null;
        }
        return req.getCodeChallenge() == null ? null : req.getCodeChallenge().getValue();
    }
}

