/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.openid.connect.sdk.claims.CodeHash;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComputeAuthorizationCodeHashFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultComputeAuthorizationCodeHashFunction.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> authorizationCodeLookupStrategy;

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    public void setAuthorizationCodeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authorizationCodeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthorizationCode lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.securityParametersLookupStrategy == null) {
            throw new ComponentInitializationException("SecurityParameterContext lookup strategy cannot be null");
        }
        if (this.authorizationCodeLookupStrategy == null) {
            throw new ComponentInitializationException("AuthorizationCode lookup strategy cannot be null");
        }
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        String rawCode = this.authorizationCodeLookupStrategy.apply(input);
        if (StringSupport.trimOrNull((String)rawCode) == null) {
            this.log.error("Could not resolve a value for authorization code to calculate the hash value");
            return null;
        }
        AuthorizationCode code = new AuthorizationCode(rawCode);
        SecurityParametersContext securityParameters = this.securityParametersLookupStrategy.apply(input);
        if (securityParameters == null || securityParameters.getSignatureSigningParameters() == null) {
            this.log.error("Could not resolve security parameters for calculating the code hash value");
            return null;
        }
        SignatureSigningParameters signingParameters = securityParameters.getSignatureSigningParameters();
        CodeHash cHash = CodeHash.compute((AuthorizationCode)code, (JWSAlgorithm)new JWSAlgorithm(signingParameters.getSignatureAlgorithm()), null);
        if (cHash == null || cHash.getValue() == null) {
            this.log.error("Not able to generate c_hash using algorithm {}", (Object)signingParameters.getSignatureAlgorithm());
            return null;
        }
        return cHash.getValue();
    }
}

