/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.logic;

import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.opensaml.profile.context.ProfileRequestContext;

public class RequestedGrantTypesCondition
implements Predicate<ProfileRequestContext> {
    @Nonnull
    @NonnullElements
    private Set<GrantType> candidates = Collections.emptySet();

    public void setGrantTypes(@Nonnull @NonnullElements Collection<GrantType> types) {
        this.candidates = Set.copyOf(types);
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        Object message;
        if (input.getInboundMessageContext() != null && (message = input.getInboundMessageContext().getMessage()) instanceof TokenRequest) {
            return this.candidates.contains(((TokenRequest)message).getAuthorizationGrant().getType());
        }
        return false;
    }
}

