/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"%{idp.duo.oidc.externalAuthnPath:/Authn/Duo/2FA}"})
@ThreadSafe
public class DuoOIDCAuthnController
extends AbstractInitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String CODE_PARAMETER = "code";
    @Nonnull
    @NotEmpty
    public static final String STATE_PARAMETER = "state";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DuoOIDCAuthnController.class);
    @Nonnull
    @GuardedBy(value="this")
    private Function<ProfileRequestContext, DuoOIDCAuthenticationContext> duoContextLookupStrategy = new ChildContextLookup(DuoOIDCAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));

    public synchronized void setDuoContextLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCAuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.duoContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoContext lookup strategy cannot be null");
    }

    private synchronized Function<ProfileRequestContext, DuoOIDCAuthenticationContext> getDuoContextLookupStrategy() {
        return this.duoContextLookupStrategy;
    }

    @GetMapping(value={"/authorize"})
    public void authorizationRequest(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws ExternalAuthenticationException, IOException {
        String key = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)httpRequest);
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        DuoOIDCAuthenticationContext duoContext = this.getDuoContextLookupStrategy().apply(prc);
        if (duoContext == null) {
            this.log.error("No Duo context to use in initiating a Duo 2FA request");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        this.log.trace("Starting Duo 2FA for integration client '{}' and user '{}'", (Object)(duoContext.getIntegration() != null ? duoContext.getIntegration().getClientId() : "none"), (Object)duoContext.getUsername());
        try {
            String authURL;
            DuoOIDCClient client = duoContext.getClient();
            if (client == null) {
                throw new DuoClientException("Duo client is null, has the context been created correctly?");
            }
            String nonce = DuoSupport.generateNonce(32);
            String state = DuoSupport.generateState(nonce, key);
            duoContext.setRequestState(nonce);
            if (client.getCapabilities().isSupportsNonce()) {
                String oidcNonce = DuoSupport.generateNonce(36);
                authURL = client.createAuthUrl(duoContext.getUsername(), state, oidcNonce, duoContext.getRedirectURIOverride());
                duoContext.setNonce(oidcNonce);
            } else {
                authURL = client.createAuthUrl(duoContext.getUsername(), state, null, duoContext.getRedirectURIOverride());
            }
            httpResponse.sendRedirect(authURL);
        }
        catch (DuoClientException e) {
            this.log.error("Could not perform Duo 2FA authorization request", (Throwable)e);
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
    }

    @GetMapping(value={"/duo-callback"})
    public void authorizationCallback(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws ExternalAuthenticationException, IOException {
        String nonce;
        String key;
        String code = httpRequest.getParameter(CODE_PARAMETER);
        String state = httpRequest.getParameter(STATE_PARAMETER);
        if (state == null || code == null) {
            throw new ExternalAuthenticationException("Duo response must contain a 'code' and 'state' parameter");
        }
        try {
            key = DuoSupport.extractKeyFromState(state);
            nonce = DuoSupport.extractNonceFromState(state);
        }
        catch (DuoException e) {
            throw new ExternalAuthenticationException("Flow execution key component could not be found in the returned state, unable to resume the flow execution", (Exception)((Object)e));
        }
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        DuoOIDCAuthenticationContext duoContext = this.getDuoContextLookupStrategy().apply(prc);
        if (duoContext == null) {
            this.log.error("No Duo authentication context to store the Duo 2FA response");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        duoContext.setAuthorizationCode(code);
        duoContext.setResponseState(nonce);
        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
    }
}

