/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.mock;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionException;

public final class MockFlowBuilder {
    private MockFlowBuilder() {
    }

    public static Flow MockNoOpFlow(@Nonnull @NotEmpty String flowId) {
        Assert.notNull((Object)flowId, (String)"Flow to mock must have an ID");
        Flow flow = new Flow(flowId);
        ActionState endingStartState = new ActionState(flow, "noop-start-start"){

            protected void doEnter(RequestControlContext context) throws FlowExecutionException {
                context.handleEvent(new Event((Object)this, "proceed"));
            }
        };
        endingStartState.getTransitionSet().add(new Transition((TargetStateResolver)new DefaultTargetStateResolver("proceed")));
        new EndState(flow, "proceed");
        flow.setStartState((State)endingStartState);
        return flow;
    }
}

