/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoSupport;
import net.shibboleth.idp.plugin.authn.duo.impl.ValidateDuoResponseState;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateDuoResponseStateTest
extends AbstractDuoActionTest {
    private ValidateDuoResponseState action;

    @BeforeMethod
    public void setUp() throws Exception {
        super.setup();
        this.action = new ValidateDuoResponseState();
    }

    @Test
    public void testExecuteSuccess() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        String nonce = DuoSupport.generateNonce((Integer)32);
        this.dc.setRequestState(nonce);
        this.dc.setResponseState(nonce);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)event);
    }

    @Test
    public void testExecuteFailed() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        String nonce = DuoSupport.generateNonce((Integer)32);
        this.dc.setRequestState(nonce);
        this.dc.setResponseState("different");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test
    public void testExecuteNoStateInRequestOrResponse() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test
    public void testExecuteNoStateInResponse() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setRequestState(DuoSupport.generateNonce((Integer)32));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test
    public void testExecuteNoStateInRequest() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setResponseState(DuoSupport.generateNonce((Integer)32));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }
}

