/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractUsernamePasswordCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class InMemoryCredentialValidator
extends AbstractUsernamePasswordCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InMemoryCredentialValidator.class);
    @Nonnull
    private final String username;
    @Nonnull
    private final String password;

    public InMemoryCredentialValidator(@Nonnull @NotEmpty String uname, @Nonnull @NotEmpty String pssword) {
        this.username = Constraint.isNotEmpty((String)uname, (String)"Username can not be null or empty");
        this.password = Constraint.isNotEmpty((String)pssword, (String)"Password can not be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
    }

    protected Subject doValidate(ProfileRequestContext profileRequestContext, AuthenticationContext authenticationContext, UsernamePasswordContext usernamePasswordContext, CredentialValidator.WarningHandler warningHandler, CredentialValidator.ErrorHandler errorHandler) throws Exception {
        String requestUsername = usernamePasswordContext.getTransformedUsername();
        String requestPassword = usernamePasswordContext.getPassword();
        this.log.debug("{} Attempting to authenticate user '{}' ", (Object)this.getLogPrefix(), (Object)this.username);
        if (this.password.equals(requestPassword) && this.username.equals(requestUsername)) {
            this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)this.username);
            return this.populateSubject(new Subject(), usernamePasswordContext);
        }
        this.log.info("{} Login by '{}' failed", (Object)this.getLogPrefix(), (Object)this.username);
        LoginException e = new LoginException("InvalidCredentials");
        if (errorHandler != null) {
            errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
        }
        throw e;
    }
}

