/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoRegistryException;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.ExchangeCodeForDuoToken;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClient_OK;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExchangeCodeForDuoTokenTest
extends AbstractDuoActionTest {
    private ExchangeCodeForDuoToken action;

    @BeforeMethod
    public void setUp() throws Exception {
        super.setup();
        this.action = new ExchangeCodeForDuoToken();
    }

    @Test
    public void testExecuteSuccess() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.dc.setAuthorizationCode("testcode");
        this.dc.setClient((DuoOIDCClient)new MockDuoOIDCClient_OK(this.dc.getIntegration()));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        AssertJUnit.assertNull((Object)event);
    }

    @Test
    public void testExecuteNoAuthCode() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.dc.setAuthorizationCode(null);
        this.dc.setClient((DuoOIDCClient)new MockDuoOIDCClient_OK(this.dc.getIntegration()));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test
    public void testExecuteNoClient() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "AuthenticationException");
    }

    @Test
    public void testExecuteNoUsername() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.dc.setAuthorizationCode("testcode");
        this.dc.setUsername(null);
        this.dc.setClient((DuoOIDCClient)new MockDuoOIDCClient_OK(this.dc.getIntegration()));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }
}

