/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoIssuerClaimLookupStrategy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DuoIssuerClaimLookupStrategyTest
extends AbstractDuoActionTest {
    @Nonnull
    private DuoIssuerClaimLookupStrategy strategy;

    @BeforeMethod
    public void beforeMethod() throws ComponentInitializationException {
        super.setup();
        this.strategy = new DuoIssuerClaimLookupStrategy("/oauth/v2/token");
    }

    @Test
    public void applySuccess() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        String issuer = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)issuer, (String)("https://" + this.dc.getIntegration().getAPIHost() + "/oauth/v2/token"));
    }

    @Test
    public void applyNoDuoContext() {
        String issuer = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)issuer, null);
    }

    @Test
    public void applyNoDuoIntegration() {
        this.addDuoContext();
        String issuer = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)issuer, null);
    }
}

