/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.impl.ExternalAuthenticationImpl;
import net.shibboleth.idp.plugin.authn.duo.DefaultDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractAuthnXmlFlowExecutionTests;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoSupport;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClientFactory_FAIL_Client;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClientFactory_OK_Client;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClient_OK;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClient_OK_OLD_AUTH_TIME;
import net.shibboleth.idp.plugin.authn.mock.MockFlowBuilder;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.junit.Test;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.execution.FlowExecution;

public class DuoAuthnFlowTest
extends AbstractAuthnXmlFlowExecutionTests {
    @Nonnull
    public static final String FIRST_INTEGRATION_SP = "https://sp.example.com/requires-first-integration";
    @Nonnull
    public static final String SECOND_INTEGRATION_SP = "https://sp.example.com/requires-second-integration";
    @Nonnull
    public static final String FIRST_INTEGRATION_CLIENT_ID = "FIRST_INTEGRATION";
    @Nonnull
    public static final String SECOND_INTEGRATION_CLIENT_ID = "SECOND_INTEGRATION";
    @Nonnull
    private static final String USERNAME = "jdoe";
    @Nonnull
    private static final String PASSWORD = "changeit";
    @Nonnull
    private static final String FLOW = "/META-INF/net/shibboleth/idp/flows/authn/DuoOIDC/duo-oidc-authn-flow.xml";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DuoAuthnFlowTest.class);
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private final List<Flow> subflows = List.of(MockFlowBuilder.MockNoOpFlow("c14n"));
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private final Map<String, String> flowResources = Map.of("classpath:/net/shibboleth/idp/flows/authn/authn-abstract-flow.xml", "authn.abstract", "classpath:/conf/authn/authn-events-flow.xml", "authn.events");

    @Test
    public void testDuoAuthnFlowDuoEndpointUnhealthy() {
        this.setFlowPath(FLOW);
        this.setFlowModelResources(this.flowResources);
        this.setSubflows(this.subflows);
        this.setClientFactory(new MockDuoOIDCClientFactory_FAIL_Client());
        Map<String, String> mockProperties = Map.of("idp.duo.oidc.redirectURL", "http://localhost/callback", "idp.duo.oidc.apiHost", "api-c9f24c5a.duosecurity.com", "idp.duo.oidc.clientId", "DIU6GEFWG5LIUBVV2M3P", "idp.duo.oidc.secretKey", "rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh", "idp.duo.oidc.user.config", "duo-oidc-authn-config.xml", "idp.duo.oidc.clientFactoryBean", "shibboleth.authn.DuoOIDC.test.clientFactory");
        this.setMockProperties(mockProperties);
        LocalAttributeMap inputMap = new LocalAttributeMap();
        inputMap.put("calledAsSubflow", (Object)true);
        FlowExecution flowExecution = this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        flowExecution.getConversationScope().put("opensamlProfileRequestContext", (Object)this.buildProfileRequestContext(false, true));
        this.updateFlowExecution(flowExecution);
        flowExecution.start((MutableAttributeMap)inputMap, (ExternalContext)this.externalContext);
        this.assertFlowExecutionEnded();
    }

    @Test
    public void testDuoAuthnFlowToAuthorizationRequest() {
        this.setFlowPath(FLOW);
        this.setFlowModelResources(this.flowResources);
        this.setSubflows(this.subflows);
        this.setClientFactory(new MockDuoOIDCClientFactory_OK_Client());
        Map<String, String> mockProperties = Map.of("idp.duo.oidc.redirectURL", "http://localhost/authorization-callback", "idp.duo.oidc.apiHost", "api-c9f24c5a.duosecurity.com", "idp.duo.oidc.clientId", "DIU6GEFWG5LIUBVV2M3P", "idp.duo.oidc.secretKey", "rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh", "idp.duo.oidc.user.config", "duo-oidc-authn-config.xml", "idp.duo.oidc.clientFactoryBean", "shibboleth.authn.DuoOIDC.test.clientFactory");
        this.setMockProperties(mockProperties);
        LocalAttributeMap inputMap = new LocalAttributeMap();
        inputMap.put("calledAsSubflow", (Object)true);
        FlowExecution flowExecution = this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        flowExecution.getConversationScope().put("opensamlProfileRequestContext", (Object)this.buildProfileRequestContext(false, true));
        this.updateFlowExecution(flowExecution);
        flowExecution.start((MutableAttributeMap)inputMap, (ExternalContext)this.externalContext);
        this.assertFlowExecutionActive();
        this.assertCurrentStateEquals("Duo2FAAuthorizationRequest");
    }

    @Test
    public void testDuoAuthnFlowToAuthorizationRequestMultipleDuoIntegrationsFirst() {
        this.setFlowPath(FLOW);
        this.setFlowModelResources(this.flowResources);
        this.setSubflows(this.subflows);
        this.setClientFactory(new MockDuoOIDCClientFactory_OK_Client());
        Map<String, String> mockProperties = Map.of("idp.duo.oidc.redirectURL", "http://localhost/authorization-callback", "idp.duo.oidc.clientFactoryBean", "shibboleth.authn.DuoOIDC.test.clientFactory", "idp.duo.oidc.user.config", "duo-oidc-authn-config-multiple-integrations.xml");
        this.setMockProperties(mockProperties);
        LocalAttributeMap inputMap = new LocalAttributeMap();
        inputMap.put("calledAsSubflow", (Object)true);
        FlowExecution flowExecution = this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        ProfileRequestContext prcOne = this.buildProfileRequestContext(false, true);
        RelyingPartyContext rpcOne = new RelyingPartyContext();
        rpcOne.setRelyingPartyId(FIRST_INTEGRATION_SP);
        prcOne.addSubcontext((BaseContext)rpcOne);
        flowExecution.getConversationScope().put("opensamlProfileRequestContext", (Object)prcOne);
        this.updateFlowExecution(flowExecution);
        flowExecution.start((MutableAttributeMap)inputMap, (ExternalContext)this.externalContext);
        this.assertFlowExecutionActive();
        this.assertCurrentStateEquals("Duo2FAAuthorizationRequest");
        DuoAuthnFlowTest.assertNotNull((Object)prcOne.getSubcontext(AuthenticationContext.class));
        DuoAuthnFlowTest.assertNotNull((Object)((AuthenticationContext)prcOne.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class));
        DuoAuthnFlowTest.assertNotNull((Object)((DuoOIDCAuthenticationContext)((AuthenticationContext)prcOne.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class)).getIntegration());
        DuoAuthnFlowTest.assertEquals((String)FIRST_INTEGRATION_CLIENT_ID, (String)((DuoOIDCAuthenticationContext)((AuthenticationContext)prcOne.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class)).getIntegration().getClientId());
    }

    @Test
    public void testDuoAuthnFlowToAuthorizationRequestMultipleDuoIntegrationsSecond() {
        this.setFlowPath(FLOW);
        this.setFlowModelResources(this.flowResources);
        this.setSubflows(this.subflows);
        this.setClientFactory(new MockDuoOIDCClientFactory_OK_Client());
        Map<String, String> mockProperties = Map.of("idp.duo.oidc.clientFactoryBean", "shibboleth.authn.DuoOIDC.test.clientFactory", "idp.duo.oidc.user.config", "duo-oidc-authn-config-multiple-integrations.xml", "idp.duo.oidc.redirectURL", "http://localhost/authorization-callback", "idp.duo.oidc.apiHost", "api-c9f24c5a.duosecurity.com", "idp.duo.oidc.clientId", "DIU6GEFWG5LIUBVV2M3P", "idp.duo.oidc.secretKey", "rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        this.setMockProperties(mockProperties);
        LocalAttributeMap inputMap = new LocalAttributeMap();
        inputMap.put("calledAsSubflow", (Object)true);
        FlowExecution flowExecution = this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        ProfileRequestContext prcOne = this.buildProfileRequestContext(false, true);
        RelyingPartyContext rpcOne = new RelyingPartyContext();
        rpcOne.setRelyingPartyId(SECOND_INTEGRATION_SP);
        prcOne.addSubcontext((BaseContext)rpcOne);
        flowExecution.getConversationScope().put("opensamlProfileRequestContext", (Object)prcOne);
        this.updateFlowExecution(flowExecution);
        flowExecution.start((MutableAttributeMap)inputMap, (ExternalContext)this.externalContext);
        this.assertFlowExecutionActive();
        this.assertCurrentStateEquals("Duo2FAAuthorizationRequest");
        DuoAuthnFlowTest.assertNotNull((Object)prcOne.getSubcontext(AuthenticationContext.class));
        DuoAuthnFlowTest.assertNotNull((Object)((AuthenticationContext)prcOne.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class));
        DuoAuthnFlowTest.assertNotNull((Object)((DuoOIDCAuthenticationContext)((AuthenticationContext)prcOne.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class)).getIntegration());
        DuoAuthnFlowTest.assertEquals((String)SECOND_INTEGRATION_CLIENT_ID, (String)((DuoOIDCAuthenticationContext)((AuthenticationContext)prcOne.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class)).getIntegration().getClientId());
    }

    @Test
    public void testDuoAuthnFlowToAuthorizationRequestWithUserSpaceFactory() {
        this.setFlowPath(FLOW);
        this.setFlowModelResources(this.flowResources);
        this.setSubflows(this.subflows);
        Map<String, String> mockProperties = Map.of("idp.duo.oidc.redirectURL", "http://localhost/authorization-callback", "idp.duo.oidc.apiHost", "api-c9f24c5a.duosecurity.com", "idp.duo.oidc.clientId", "DIU6GEFWG5LIUBVV2M3P", "idp.duo.oidc.secretKey", "rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh", "idp.duo.oidc.clientFactoryBean", "shibboleth.authn.DuoOIDC.test.clientFactory", "idp.duo.oidc.user.config", "duo-oidc-authn-config-custom-factory.xml");
        this.setMockProperties(mockProperties);
        LocalAttributeMap inputMap = new LocalAttributeMap();
        inputMap.put("calledAsSubflow", (Object)true);
        FlowExecution flowExecution = this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        flowExecution.getConversationScope().put("opensamlProfileRequestContext", (Object)this.buildProfileRequestContext(false, true));
        this.updateFlowExecution(flowExecution);
        flowExecution.start((MutableAttributeMap)inputMap, (ExternalContext)this.externalContext);
        this.assertFlowExecutionActive();
        this.assertCurrentStateEquals("Duo2FAAuthorizationRequest");
    }

    @Test
    public void testContextToPrincipalMappingStrategy() throws DuoClientException {
        this.setFlowPath(FLOW);
        this.setFlowModelResources(this.flowResources);
        this.setSubflows(this.subflows);
        this.setClientFactory(new MockDuoOIDCClientFactory_OK_Client());
        Map<String, String> mockProperties = Map.of("idp.duo.oidc.redirectURL", "http://localhost/authorization-callback", "idp.duo.oidc.apiHost", "api-c9f24c5a.duosecurity.com", "idp.duo.oidc.clientId", "DIU6GEFWG5LIUBVV2M3P", "idp.duo.oidc.secretKey", "rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh", "idp.duo.oidc.clientFactoryBean", "shibboleth.authn.DuoOIDC.test.clientFactory", "idp.duo.oidc.user.config", "duo-oidc-authn-config-principal-mapping.xml");
        this.setMockProperties(mockProperties);
        LocalAttributeMap inputMap = new LocalAttributeMap();
        inputMap.put("calledAsSubflow", (Object)true);
        FlowExecutionImpl flowExecution = (FlowExecutionImpl)this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        ProfileRequestContext prc = this.buildProfileRequestContext(false, false);
        DuoOIDCAuthenticationContext duoContext = new DuoOIDCAuthenticationContext();
        String nonce = DuoSupport.generateNonce((Integer)32);
        duoContext.setAuthorizationCode("adummycode");
        duoContext.setRequestState(nonce);
        duoContext.setResponseState(nonce);
        duoContext.setUsername(USERNAME);
        DefaultDuoOIDCIntegration integ = new DefaultDuoOIDCIntegration();
        integ.setClientId("DIU6GEFWG5LIUBVV2M3P");
        integ.setAPIHost("api-c9f24c5a.duosecurity.com");
        integ.setSecretKey("rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        integ.setAuthorizeEndpoint("/authorize");
        integ.setHealthCheckEndpoint("/health");
        integ.setTokenEndpoint("/token");
        integ.setRegisteredRedirectURI("http://localhost/authorization-callback");
        duoContext.setIntegration((DuoOIDCIntegration)integ);
        duoContext.setClient((DuoOIDCClient)new MockDuoOIDCClient_OK(duoContext.getIntegration()));
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).addSubcontext((BaseContext)duoContext);
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).addSubcontext((BaseContext)new ExternalAuthenticationContext((ExternalAuthentication)new ExternalAuthenticationImpl(false)));
        flowExecution.getConversationScope().put("opensamlProfileRequestContext", (Object)prc);
        this.updateFlowExecution((FlowExecution)flowExecution);
        this.externalContext.setEventId("proceed");
        this.setCurrentState("Duo2FAAuthorizationRequest");
        this.resumeFlow((ExternalContext)this.externalContext);
        this.assertFlowExecutionEnded();
        DuoAuthnFlowTest.assertNotNull((Object)prc.getSubcontext(AuthenticationContext.class));
        DuoAuthnFlowTest.assertNotNull((Object)prc.getSubcontext(SubjectCanonicalizationContext.class));
        DuoAuthnFlowTest.assertEquals((String)((SubjectCanonicalizationContext)prc.getSubcontext(SubjectCanonicalizationContext.class)).getPrincipalName(), (String)USERNAME);
        Set<AuthnContextClassRefPrincipal> principals = ((SubjectCanonicalizationContext)prc.getSubcontext(SubjectCanonicalizationContext.class)).getSubject().getPrincipals(AuthnContextClassRefPrincipal.class);
        DuoAuthnFlowTest.assertEquals((int)1, (int)principals.size());
        DuoAuthnFlowTest.assertEquals((String)"http://example.org/ac/classes/mfa/strong", (String)principals.iterator().next().getName());
    }

    @Test
    public void testDuoAuthnFlowFromAuthorizationCallback() throws DuoClientException {
        this.setRemoveDefaultContextCleanupHook(true);
        this.setFlowPath(FLOW);
        this.setFlowModelResources(this.flowResources);
        this.setSubflows(this.subflows);
        this.setClientFactory(new MockDuoOIDCClientFactory_OK_Client());
        Map<String, String> mockProperties = Map.of("idp.duo.oidc.user.config", "duo-oidc-authn-config.xml", "idp.duo.oidc.clientFactoryBean", "shibboleth.authn.DuoOIDC.test.clientFactory", "idp.duo.oidc.redirectURL", "http://localhost/authorization-callback", "idp.duo.oidc.apiHost", "api-c9f24c5a.duosecurity.com", "idp.duo.oidc.clientId", "DIU6GEFWG5LIUBVV2M3P", "idp.duo.oidc.secretKey", "rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        this.setMockProperties(mockProperties);
        FlowExecutionImpl flowExecution = (FlowExecutionImpl)this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        ProfileRequestContext prc = this.buildProfileRequestContext(false, false);
        DuoOIDCAuthenticationContext duoContext = new DuoOIDCAuthenticationContext();
        String nonce = DuoSupport.generateNonce((Integer)32);
        duoContext.setAuthorizationCode("adummycode");
        duoContext.setRequestState(nonce);
        duoContext.setResponseState(nonce);
        duoContext.setUsername(USERNAME);
        DefaultDuoOIDCIntegration integ = new DefaultDuoOIDCIntegration();
        integ.setClientId("DIU6GEFWG5LIUBVV2M3P");
        integ.setAPIHost("api-c9f24c5a.duosecurity.com");
        integ.setSecretKey("rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        integ.setAuthorizeEndpoint("/authorize");
        integ.setHealthCheckEndpoint("/health");
        integ.setTokenEndpoint("/token");
        integ.setRegisteredRedirectURI("http://localhost/authorization-callback");
        duoContext.setIntegration((DuoOIDCIntegration)integ);
        duoContext.setClient((DuoOIDCClient)new MockDuoOIDCClient_OK(duoContext.getIntegration()));
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).addSubcontext((BaseContext)duoContext);
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).addSubcontext((BaseContext)new ExternalAuthenticationContext((ExternalAuthentication)new ExternalAuthenticationImpl(false)));
        flowExecution.getConversationScope().put("opensamlProfileRequestContext", (Object)prc);
        this.updateFlowExecution((FlowExecution)flowExecution);
        this.externalContext.setEventId("proceed");
        this.setCurrentState("Duo2FAAuthorizationRequest");
        this.resumeFlow((ExternalContext)this.externalContext);
        this.assertFlowExecutionEnded();
        DuoAuthnFlowTest.assertNotNull((Object)prc.getSubcontext(AuthenticationContext.class));
        DuoAuthnFlowTest.assertNotNull((Object)((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class));
        DuoOIDCAuthenticationContext contextFromPrc = (DuoOIDCAuthenticationContext)((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class);
        DuoAuthnFlowTest.assertNotNull((Object)contextFromPrc.getAuthToken());
        DuoAuthnFlowTest.assertNotNull((Object)prc.getSubcontext(SubjectCanonicalizationContext.class));
        DuoAuthnFlowTest.assertEquals((String)((SubjectCanonicalizationContext)prc.getSubcontext(SubjectCanonicalizationContext.class)).getPrincipalName(), (String)USERNAME);
    }

    @Test
    public void testDuoAuthnFlowFromAuthorizationCallbackWithRPC() throws DuoClientException {
        this.setRemoveDefaultContextCleanupHook(true);
        this.setFlowPath(FLOW);
        this.setFlowModelResources(this.flowResources);
        this.setSubflows(this.subflows);
        this.setClientFactory(new MockDuoOIDCClientFactory_OK_Client());
        Map<String, String> mockProperties = Map.of("idp.duo.oidc.clientFactoryBean", "shibboleth.authn.DuoOIDC.test.clientFactory", "idp.duo.oidc.user.config", "duo-oidc-authn-config.xml", "idp.duo.oidc.redirectURL", "http://localhost/authorization-callback", "idp.duo.oidc.apiHost", "api-c9f24c5a.duosecurity.com", "idp.duo.oidc.clientId", "DIU6GEFWG5LIUBVV2M3P", "idp.duo.oidc.secretKey", "rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        this.setMockProperties(mockProperties);
        FlowExecutionImpl flowExecution = (FlowExecutionImpl)this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        ProfileRequestContext prc = this.buildProfileRequestContext(false, false);
        DuoOIDCAuthenticationContext duoContext = new DuoOIDCAuthenticationContext();
        String nonce = DuoSupport.generateNonce((Integer)32);
        duoContext.setAuthorizationCode("adummycode");
        duoContext.setRequestState(nonce);
        duoContext.setResponseState(nonce);
        duoContext.setUsername(USERNAME);
        DefaultDuoOIDCIntegration integ = new DefaultDuoOIDCIntegration();
        integ.setClientId("DIU6GEFWG5LIUBVV2M3P");
        integ.setAPIHost("api-c9f24c5a.duosecurity.com");
        integ.setSecretKey("rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        integ.setAuthorizeEndpoint("/authorize");
        integ.setHealthCheckEndpoint("/health");
        integ.setTokenEndpoint("/token");
        integ.setRegisteredRedirectURI("http://localhost/authorization-callback");
        duoContext.setIntegration((DuoOIDCIntegration)integ);
        duoContext.setClient((DuoOIDCClient)new MockDuoOIDCClient_OK(duoContext.getIntegration()));
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).addSubcontext((BaseContext)duoContext);
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).addSubcontext((BaseContext)new ExternalAuthenticationContext((ExternalAuthentication)new ExternalAuthenticationImpl(false)));
        RequestedPrincipalContext rpc = new RequestedPrincipalContext();
        List<AuthnContextClassRefPrincipal> requestedPrincipals = List.of(new AuthnContextClassRefPrincipal("http://example.org/ac/classes/mfa"));
        rpc.setRequestedPrincipals(requestedPrincipals);
        rpc.setOperator("exact");
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).addSubcontext((BaseContext)rpc);
        AuthenticationFlowDescriptor afd = new AuthenticationFlowDescriptor();
        afd.setId("authn/DuoOIDC");
        afd.setSupportedPrincipals(List.of(new AuthnContextClassRefPrincipal("http://example.org/ac/classes/mfa")));
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).setAttemptedFlow(afd);
        flowExecution.getConversationScope().put("opensamlProfileRequestContext", (Object)prc);
        this.updateFlowExecution((FlowExecution)flowExecution);
        this.externalContext.setEventId("proceed");
        this.setCurrentState("Duo2FAAuthorizationRequest");
        this.resumeFlow((ExternalContext)this.externalContext);
        this.assertFlowExecutionEnded();
        DuoAuthnFlowTest.assertNotNull((Object)prc.getSubcontext(AuthenticationContext.class));
        DuoAuthnFlowTest.assertNotNull((Object)((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class));
        DuoOIDCAuthenticationContext contextFromPrc = (DuoOIDCAuthenticationContext)((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class);
        DuoAuthnFlowTest.assertNotNull((Object)contextFromPrc.getAuthToken());
        DuoAuthnFlowTest.assertNotNull((Object)prc.getSubcontext(SubjectCanonicalizationContext.class));
        DuoAuthnFlowTest.assertEquals((String)((SubjectCanonicalizationContext)prc.getSubcontext(SubjectCanonicalizationContext.class)).getPrincipalName(), (String)USERNAME);
    }

    @Test
    public void testDuoAuthnFlowFromAuthorizationCallbackForceAuthnFailure() throws DuoClientException {
        this.setFlowPath(FLOW);
        this.setFlowModelResources(this.flowResources);
        this.setSubflows(this.subflows);
        this.setClientFactory(new MockDuoOIDCClientFactory_OK_Client());
        Map<String, String> mockProperties = Map.of("idp.duo.oidc.clientFactoryBean", "shibboleth.authn.DuoOIDC.test.clientFactory", "idp.duo.oidc.user.config", "duo-oidc-authn-config.xml", "idp.duo.oidc.redirectURL", "http://localhost/authorization-callback", "idp.duo.oidc.apiHost", "api-c9f24c5a.duosecurity.com", "idp.duo.oidc.clientId", "DIU6GEFWG5LIUBVV2M3P", "idp.duo.oidc.secretKey", "rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        this.setMockProperties(mockProperties);
        FlowExecutionImpl flowExecution = (FlowExecutionImpl)this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        ProfileRequestContext prc = this.buildProfileRequestContext(true, false);
        DuoOIDCAuthenticationContext duoContext = new DuoOIDCAuthenticationContext();
        String nonce = DuoSupport.generateNonce((Integer)32);
        duoContext.setAuthorizationCode("adummycode");
        duoContext.setRequestState(nonce);
        duoContext.setResponseState(nonce);
        duoContext.setUsername(USERNAME);
        DefaultDuoOIDCIntegration integ = new DefaultDuoOIDCIntegration();
        integ.setClientId("DIU6GEFWG5LIUBVV2M3P");
        integ.setAPIHost("api-c9f24c5a.duosecurity.com");
        integ.setSecretKey("rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        integ.setRegisteredRedirectURI("http://localhost/authorization-callback");
        integ.setAuthorizeEndpoint("/authorize");
        integ.setHealthCheckEndpoint("/health");
        integ.setTokenEndpoint("/token");
        duoContext.setIntegration((DuoOIDCIntegration)integ);
        duoContext.setClient((DuoOIDCClient)new MockDuoOIDCClient_OK_OLD_AUTH_TIME(duoContext.getIntegration()));
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).addSubcontext((BaseContext)duoContext);
        ((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).addSubcontext((BaseContext)new ExternalAuthenticationContext((ExternalAuthentication)new ExternalAuthenticationImpl(false)));
        flowExecution.getConversationScope().put("opensamlProfileRequestContext", (Object)prc);
        this.updateFlowExecution((FlowExecution)flowExecution);
        this.externalContext.setEventId("proceed");
        this.setCurrentState("Duo2FAAuthorizationRequest");
        this.resumeFlow((ExternalContext)this.externalContext);
        this.assertFlowExecutionEnded();
        DuoAuthnFlowTest.assertNotNull((Object)prc.getSubcontext(EventContext.class));
        DuoAuthnFlowTest.assertNotNull((Object)((EventContext)prc.getSubcontext(EventContext.class)).getEvent());
        DuoAuthnFlowTest.assertTrue((boolean)(((EventContext)prc.getSubcontext(EventContext.class)).getEvent() instanceof String));
        DuoAuthnFlowTest.assertEquals((Object)"NoCredentials", (Object)((EventContext)prc.getSubcontext(EventContext.class)).getEvent());
    }
}

