/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.Principal;
import java.time.Instant;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.impl.StorageBackedIdPSession;
import net.shibboleth.idp.session.impl.StorageBackedIdPSessionSerializer;
import net.shibboleth.idp.session.impl.StorageBackedSessionManager;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.CookieManager;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletRequestProxy;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletResponseProxy;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StorageBackedIdPSessionSerializerTest {
    private static final String DATAPATH = "/net/shibboleth/idp/session/impl/";
    private static final long INSTANT = 1378827849463L;
    private static final String CONTEXT = "context";
    private static final String KEY = "key";
    private StorageBackedSessionManager manager;
    private StorageBackedIdPSessionSerializer serializer;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        MemoryStorageService storageService = new MemoryStorageService();
        storageService.setId("TestStorageService");
        storageService.initialize();
        CookieManager cookieManager = new CookieManager();
        cookieManager.setHttpServletRequest((HttpServletRequest)new ThreadLocalHttpServletRequestProxy());
        cookieManager.setHttpServletResponse((HttpServletResponse)new ThreadLocalHttpServletResponseProxy());
        cookieManager.initialize();
        this.manager = new StorageBackedSessionManager();
        this.manager.setStorageService((StorageService)storageService);
        this.manager.setIDGenerator((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy());
        this.manager.setHttpServletRequest((HttpServletRequest)new ThreadLocalHttpServletRequestProxy());
        this.manager.setHttpServletResponse((HttpServletResponse)new ThreadLocalHttpServletResponseProxy());
        this.manager.setCookieManager(cookieManager);
        this.manager.setId("Test Session Manager");
        this.manager.setTrackSPSessions(true);
        this.manager.setSPSessionSerializerRegistry(new SPSessionSerializerRegistry());
        this.manager.initialize();
        this.serializer = new StorageBackedIdPSessionSerializer(this.manager, null);
        this.serializer.initialize();
    }

    @Test
    public void testInvalid() throws Exception {
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/session/impl/invalid.json"), Long.valueOf(1378827849463L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/session/impl/noInstant.json"), Long.valueOf(1378827849463L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/session/impl/noName.json"), Long.valueOf(1378827849463L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/session/impl/basicIdPSession.json"), null);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBasic() throws Exception {
        long exp = 1378831449463L;
        StorageBackedIdPSession session = new StorageBackedIdPSession(this.manager, "test", "foo", Instant.ofEpochMilli(1378827849463L));
        session.doBindToAddress("127.0.0.1");
        String s = this.serializer.serialize(session);
        String s2 = this.fileToString("/net/shibboleth/idp/session/impl/basicIdPSession.json");
        Assert.assertEquals((String)s, (String)s2);
        StorageBackedIdPSession session2 = this.serializer.deserialize(1L, "test", KEY, s2, Long.valueOf(exp));
        Assert.assertEquals((String)session.getId(), (String)session2.getId());
        Assert.assertEquals((String)session.getPrincipalName(), (String)session2.getPrincipalName());
        Assert.assertEquals((Object)session.getCreationInstant(), (Object)session2.getCreationInstant());
        Assert.assertEquals((Object)session.getLastActivityInstant(), (Object)session2.getLastActivityInstant());
    }

    @Test
    public void testComplex() throws Exception {
        Instant exp = Instant.ofEpochMilli(1378827849463L).plusSeconds(3600L);
        StorageBackedIdPSession session = new StorageBackedIdPSession(this.manager, "test", "foo", Instant.ofEpochMilli(1378827849463L));
        session.doBindToAddress("127.0.0.1");
        session.doAddAuthenticationResult(new AuthenticationResult("a", (Principal)new UsernamePrincipal("jdoe")));
        session.doAddAuthenticationResult(new AuthenticationResult("b", (Principal)new UsernamePrincipal("jdoe")));
        session.doAddAuthenticationResult(new AuthenticationResult("c", (Principal)new UsernamePrincipal("jdoe")));
        session.doAddSPSession((SPSession)new BasicSPSession("bar", Instant.ofEpochMilli(1378827849463L), exp));
        session.doAddSPSession((SPSession)new BasicSPSession("baz", Instant.ofEpochMilli(1378827849463L), exp));
        String s2 = this.fileToString("/net/shibboleth/idp/session/impl/complexIdPSession.jdk8");
        StorageBackedIdPSession session2 = this.serializer.deserialize(1L, "test", KEY, s2, Long.valueOf(exp.toEpochMilli()));
        Assert.assertEquals((String)session.getId(), (String)session2.getId());
        Assert.assertEquals((String)session.getPrincipalName(), (String)session2.getPrincipalName());
        Assert.assertEquals((Object)session.getCreationInstant(), (Object)session2.getCreationInstant());
        Assert.assertEquals((Object)session.getLastActivityInstant(), (Object)session2.getLastActivityInstant());
    }

    private String fileToString(String pathname) throws URISyntaxException, IOException {
        try (FileInputStream stream = new FileInputStream(new File(StorageBackedIdPSessionSerializerTest.class.getResource(pathname).toURI()));){
            int avail = stream.available();
            byte[] data = new byte[avail];
            int numRead = 0;
            int pos = 0;
            do {
                if (pos + avail > data.length) {
                    byte[] newData = new byte[pos + avail];
                    System.arraycopy(data, 0, newData, 0, pos);
                    data = newData;
                }
                if ((numRead = stream.read(data, pos, avail)) < 0) continue;
                pos += numRead;
            } while ((avail = stream.available()) > 0 && numRead >= 0);
            String string = new String(data, 0, pos, "UTF-8");
            return string;
        }
    }
}

