/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.security.Principal;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.impl.DetectIdentitySwitch;
import net.shibboleth.idp.session.impl.testing.SessionManagerBaseTestCase;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DetectIdentitySwitchTest
extends SessionManagerBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private AuthenticationContext ac;
    private SessionContext sc;
    private SubjectCanonicalizationContext c14n;
    private DetectIdentitySwitch action;

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true);
        this.sc = (SessionContext)this.prc.getSubcontext(SessionContext.class, true);
        this.c14n = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        this.action = new DetectIdentitySwitch();
        this.action.setSessionManager((SessionManager)this.sessionManager);
        this.action.initialize();
    }

    @Test
    public void testNoSession() {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.c14n.setPrincipalName("joe");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testSesssion() throws SessionException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.sc.setIdPSession(this.sessionManager.createSession("joe"));
        this.ac.setActiveResults(Collections.singletonList(new AuthenticationResult("test1", (Principal)new UsernamePrincipal("joe"))));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.sc.getIdPSession());
        Assert.assertEquals((int)this.ac.getActiveResults().size(), (int)1);
    }

    @Test
    public void testMatch() throws SessionException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.sc.setIdPSession(this.sessionManager.createSession("joe"));
        this.ac.setActiveResults(Collections.singletonList(new AuthenticationResult("test1", (Principal)new UsernamePrincipal("joe"))));
        this.c14n.setPrincipalName("joe");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.sc.getIdPSession());
        Assert.assertEquals((int)this.ac.getActiveResults().size(), (int)1);
    }

    @Test
    public void testMismatch() throws SessionException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.sc.setIdPSession(this.sessionManager.createSession("joe"));
        this.ac.setActiveResults(Collections.singletonList(new AuthenticationResult("test1", (Principal)new UsernamePrincipal("joe"))));
        this.c14n.setPrincipalName("joe2");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"IdentitySwitch");
        Assert.assertNull((Object)this.sc.getIdPSession());
        Assert.assertEquals((int)this.ac.getActiveResults().size(), (int)0);
    }
}

