/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractIdPSession
implements IdPSession {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractIdPSession.class);
    @Nonnull
    @NotEmpty
    private final String id;
    @Nonnull
    @NotEmpty
    private final String principalName;
    @Duration
    private final long creationInstant;
    @Duration
    private long lastActivityInstant;
    @Nullable
    private String ipV4Address;
    @Nullable
    private String ipV6Address;
    @Nonnull
    private final ConcurrentMap<String, Optional<AuthenticationResult>> authenticationResults;
    @Nonnull
    private final ConcurrentMap<String, Optional<SPSession>> spSessions;

    public AbstractIdPSession(@Nonnull @NotEmpty String sessionId, @Nonnull @NotEmpty String canonicalName, @Positive long creationTime) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sessionId), (String)"Session ID cannot be null or empty");
        this.principalName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)canonicalName), (String)"Principal name cannot be null or empty.");
        this.creationInstant = Constraint.isGreaterThan((long)0L, (long)creationTime, (String)"Creation time must be greater than 0");
        this.lastActivityInstant = creationTime;
        this.authenticationResults = new ConcurrentHashMap<String, Optional<AuthenticationResult>>(5);
        this.spSessions = new ConcurrentHashMap<String, Optional<SPSession>>(10);
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getPrincipalName() {
        return this.principalName;
    }

    @Override
    public long getCreationInstant() {
        return this.creationInstant;
    }

    @Override
    public long getLastActivityInstant() {
        return this.lastActivityInstant;
    }

    public void setLastActivityInstant(@Duration @Positive long instant) throws SessionException {
        this.doSetLastActivityInstant(instant);
    }

    public void doSetLastActivityInstant(@Duration @Positive long instant) {
        this.lastActivityInstant = Constraint.isGreaterThan((long)0L, (long)instant, (String)"Last activity instant must be greater than 0");
    }

    @Nullable
    public String getAddress(@Nonnull AddressFamily family) {
        switch (family) {
            case IPV4: {
                return this.ipV4Address;
            }
            case IPV6: {
                return this.ipV6Address;
            }
        }
        return null;
    }

    public void bindToAddress(@Nonnull @NotEmpty String address) throws SessionException {
        this.doBindToAddress(address);
    }

    public void doBindToAddress(@Nonnull @NotEmpty String address) {
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)address), (String)"Address cannot be null or empty");
        switch (AbstractIdPSession.getAddressFamily(address)) {
            case IPV6: {
                this.ipV6Address = StringSupport.trimOrNull((String)trimmed);
                break;
            }
            case IPV4: {
                this.ipV4Address = StringSupport.trimOrNull((String)trimmed);
                break;
            }
            default: {
                this.log.warn("Unsupported address form {}", (Object)address);
            }
        }
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<AuthenticationResult> getAuthenticationResults() {
        return ImmutableSet.copyOf((Iterable)Optional.presentInstances(this.authenticationResults.values()));
    }

    @Override
    @Nullable
    public AuthenticationResult getAuthenticationResult(@Nonnull @NotEmpty String flowId) {
        Optional mapped = (Optional)this.authenticationResults.get(StringSupport.trimOrNull((String)flowId));
        return mapped != null ? (AuthenticationResult)mapped.orNull() : null;
    }

    @Override
    @Nullable
    public AuthenticationResult addAuthenticationResult(@Nonnull AuthenticationResult result) throws SessionException {
        return this.doAddAuthenticationResult(result);
    }

    @Override
    public boolean removeAuthenticationResult(@Nonnull AuthenticationResult result) throws SessionException {
        return this.doRemoveAuthenticationResult(result);
    }

    @Nullable
    public AuthenticationResult doAddAuthenticationResult(@Nonnull AuthenticationResult result) {
        Constraint.isNotNull((Object)result, (String)"AuthenticationResult cannot be null");
        Optional<AuthenticationResult> prev = this.authenticationResults.put(result.getAuthenticationFlowId(), (Optional<AuthenticationResult>)Optional.of((Object)result));
        if (prev != null && prev.isPresent()) {
            this.log.debug("IdPSession {}: replaced old AuthenticationResult for flow ID {}", (Object)this.id, (Object)((AuthenticationResult)prev.get()).getAuthenticationFlowId());
            return (AuthenticationResult)prev.get();
        }
        return null;
    }

    public boolean doRemoveAuthenticationResult(@Nonnull AuthenticationResult result) {
        Constraint.isNotNull((Object)result, (String)"Authentication event can not be null");
        if (this.authenticationResults.remove(result.getAuthenticationFlowId(), Optional.of((Object)result))) {
            return true;
        }
        return this.authenticationResults.remove(result.getAuthenticationFlowId(), Optional.absent());
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<SPSession> getSPSessions() {
        return ImmutableSet.copyOf((Iterable)Optional.presentInstances(this.spSessions.values()));
    }

    @Override
    @Nullable
    public SPSession getSPSession(@Nonnull @NotEmpty String serviceId) {
        Optional mapped = (Optional)this.spSessions.get(StringSupport.trimOrNull((String)serviceId));
        return mapped != null ? (SPSession)mapped.orNull() : null;
    }

    @Override
    @Nullable
    public SPSession addSPSession(@Nonnull SPSession spSession) throws SessionException {
        return this.doAddSPSession(spSession);
    }

    @Override
    public boolean removeSPSession(@Nonnull SPSession spSession) throws SessionException {
        return this.doRemoveSPSession(spSession);
    }

    @Nullable
    public SPSession doAddSPSession(@Nonnull SPSession spSession) {
        Constraint.isNotNull((Object)spSession, (String)"SPSession cannot be null");
        Optional<SPSession> prev = this.spSessions.put(spSession.getId(), (Optional<SPSession>)Optional.of((Object)spSession));
        if (prev != null && prev.isPresent()) {
            this.log.debug("IdPSession {}: replaced old SPSession for service {}", (Object)this.id, (Object)((SPSession)prev.get()).getId());
            return (SPSession)prev.get();
        }
        return null;
    }

    public boolean doRemoveSPSession(@Nonnull SPSession spSession) {
        Constraint.isNotNull((Object)spSession, (String)"SPSession cannot be null");
        if (this.spSessions.remove(spSession.getId(), Optional.of((Object)spSession))) {
            return true;
        }
        return this.spSessions.remove(spSession.getId(), Optional.absent());
    }

    @Override
    public boolean checkAddress(@Nonnull @NotEmpty String address) throws SessionException {
        AddressFamily family = AbstractIdPSession.getAddressFamily(address);
        if (family == AddressFamily.UNKNOWN) {
            this.log.warn("Address {} is of unknown type", (Object)address);
            return false;
        }
        String bound = this.getAddress(family);
        if (bound != null) {
            if (!bound.equals(address)) {
                this.log.warn("Client address is {} but session {} already bound to {}", new Object[]{address, this.id, bound});
                return false;
            }
        } else {
            this.log.info("Session {} not yet locked to a {} address, locking it to {}", new Object[]{this.id, family, address});
            try {
                this.bindToAddress(address);
            }
            catch (SessionException e) {
                this.log.error("Unable to bind session {} to address {}", (Object)this.id, (Object)address);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkTimeout() throws SessionException {
        this.setLastActivityInstant(System.currentTimeMillis());
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractIdPSession) {
            return Objects.equals(this.getId(), ((AbstractIdPSession)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sessionId", (Object)this.id).add("principalName", (Object)this.principalName).add("IPv4", (Object)this.ipV4Address).add("IPv6", (Object)this.ipV6Address).add("creationInstant", (Object)new DateTime(this.creationInstant)).add("lastActivityInstant", (Object)new DateTime(this.lastActivityInstant)).add("authenticationResults", this.getAuthenticationResults()).add("spSessions", this.getSPSessions()).toString();
    }

    @Nonnull
    @NonnullElements
    @Live
    protected Map<String, Optional<AuthenticationResult>> getAuthenticationResultMap() {
        return this.authenticationResults;
    }

    @Nonnull
    @NonnullElements
    @Live
    protected Map<String, Optional<SPSession>> getSPSessionMap() {
        return this.spSessions;
    }

    @Nonnull
    protected static AddressFamily getAddressFamily(@Nonnull @NotEmpty String address) {
        if (address.contains(":")) {
            return AddressFamily.IPV6;
        }
        if (address.contains(".")) {
            return AddressFamily.IPV4;
        }
        return AddressFamily.UNKNOWN;
    }

    public static enum AddressFamily {
        IPV4,
        IPV6,
        UNKNOWN;

    }
}

