/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.metadata.impl.AttributeMappingNodeProcessor;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRequestedAttributesInAttributeConsumingService
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MapRequestedAttributesInAttributeConsumingService.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeConsumingServiceContext> attributeConsumingServiceContextLookupStrategy = new ChildContextLookup(AttributeConsumingServiceContext.class).compose(new ChildContextLookup(SAMLMetadataContext.class).compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new InboundMessageContextLookup())));
    @Nullable
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    private AttributeConsumingServiceContext acsContext;

    public void setAttributeConsumingServiceContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeConsumingServiceContext> strategy) {
        this.attributeConsumingServiceContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeConsumingServiceContext lookup strategy cannot be null");
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeResolver cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.acsContext = this.attributeConsumingServiceContextLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.acsContext == null) {
            this.log.trace("{} AttributeConsumingServiceContext not found", (Object)this.getLogPrefix());
            return;
        }
        AttributeConsumingService acs = this.acsContext.getAttributeConsumingService();
        if (acs == null) {
            this.log.trace("{} No AttributeConsumingService to map", (Object)this.getLogPrefix());
            return;
        }
        if (acs.getRequestedAttributes().isEmpty() || acs.getObjectMetadata().containsKey(AttributesMapContainer.class) || acs.getParent() != null) {
            this.log.trace("{} Skipping decode of AttributeConsumingService", (Object)this.getLogPrefix());
            return;
        }
        try {
            AttributeMappingNodeProcessor processor = new AttributeMappingNodeProcessor(this.transcoderRegistry);
            this.log.debug("{} Decoding RequestedAttributes for generated AttributeConsumingService", (Object)this.getLogPrefix());
            processor.process((XMLObject)acs);
        }
        catch (FilterException e) {
            this.log.error("{} Error decoding RequestedAttributes", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RuntimeException");
        }
    }
}

