/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Scoping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAuthnRequest
extends AbstractAuthenticationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAuthnRequest.class);
    private boolean overwriteExisting;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = prc -> new SecureRandomIdentifierGenerationStrategy();
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private BrowserSSOProfileConfiguration profileConfiguration;
    @Nullable
    private String issuerId;

    public AddAuthnRequest() {
        this.setAuthenticationContextLookupStrategy((Function)new ParentContextLookup(AuthenticationContext.class));
    }

    public void setOverwriteExisting(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.overwriteExisting = flag;
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = strategy;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        if (rpCtx != null && rpCtx.getConfiguration() != null && rpCtx.getProfileConfig() instanceof BrowserSSOProfileConfiguration) {
            this.profileConfiguration = (BrowserSSOProfileConfiguration)rpCtx.getProfileConfig();
        }
        if (this.profileConfiguration == null) {
            this.log.error("{} BrowserSSOProfileConfiguration not found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        if (outboundMessageCtx == null) {
            this.log.debug("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (!this.overwriteExisting && outboundMessageCtx.getMessage() != null) {
            this.log.debug("{} Outbound message context already contains a message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.issuerLookupStrategy != null) {
            this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        }
        outboundMessageCtx.setMessage(null);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.log.debug("{} Building AuthnRequest for upstream IdP ({})", (Object)this.getLogPrefix(), (Object)authenticationContext.getAuthenticatingAuthority());
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(AuthnRequest.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder nipBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        AuthnRequest object = (AuthnRequest)requestBuilder.buildObject();
        object.setID(this.idGenerator.generateIdentifier());
        object.setIssueInstant(Instant.now());
        object.setVersion(SAMLVersion.VERSION_20);
        if (this.issuerId != null) {
            this.log.debug("{} Setting Issuer to {}", (Object)this.getLogPrefix(), (Object)this.issuerId);
            SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(Issuer.DEFAULT_ELEMENT_NAME);
            Issuer issuer = (Issuer)issuerBuilder.buildObject();
            issuer.setValue(this.issuerId);
            object.setIssuer(issuer);
        } else {
            this.log.debug("{} No issuer value available, leaving Issuer unset", (Object)this.getLogPrefix());
        }
        if (this.profileConfiguration.isForceAuthn(profileRequestContext)) {
            this.log.debug("{} Setting ForceAuthn for SAML AuthnRequest", (Object)this.getLogPrefix());
            object.setForceAuthn(Boolean.valueOf(true));
        }
        if (authenticationContext.isPassive()) {
            this.log.debug("{} Setting IsPassive for SAML AuthnRequest", (Object)this.getLogPrefix());
            object.setIsPassive(Boolean.valueOf(true));
        }
        NameIDPolicy nip = (NameIDPolicy)nipBuilder.buildObject();
        nip.setAllowCreate(Boolean.valueOf(true));
        List formats = this.profileConfiguration.getNameIDFormatPrecedence(profileRequestContext);
        if (!formats.isEmpty()) {
            this.log.debug("{} Setting NameIDPolicy Format to '{}' for SAML AuthnRequest", (Object)this.getLogPrefix(), formats.get(0));
            nip.setFormat((String)formats.get(0));
        }
        object.setNameIDPolicy(nip);
        RequestedAuthnContext rac = this.getRequestedAuthnContext(profileRequestContext);
        if (rac != null) {
            AuthnContextComparisonTypeEnumeration operator = this.profileConfiguration.getAuthnContextComparison(profileRequestContext);
            if (operator != null) {
                this.log.debug("{} Setting RequestedAuthnContext comparison to {}", (Object)this.getLogPrefix(), (Object)operator);
                rac.setComparison(operator);
            }
            object.setRequestedAuthnContext(rac);
        }
        object.setScoping(this.buildScoping(profileRequestContext, authenticationContext.getProxyCount(), authenticationContext.getProxiableAuthorities()));
        profileRequestContext.getOutboundMessageContext().setMessage((Object)object);
    }

    @Nullable
    private RequestedAuthnContext getRequestedAuthnContext(@Nullable ProfileRequestContext profileRequestContext) {
        List principals = this.profileConfiguration.getDefaultAuthenticationMethods(profileRequestContext);
        if (principals.isEmpty()) {
            return null;
        }
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder builder = (SAMLObjectBuilder)bf.getBuilderOrThrow(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        List classRefPrincipals = principals.stream().filter(AuthnContextClassRefPrincipal.class::isInstance).map(AuthnContextClassRefPrincipal.class::cast).collect(Collectors.toUnmodifiableList());
        if (!classRefPrincipals.isEmpty()) {
            RequestedAuthnContext rac = (RequestedAuthnContext)builder.buildObject();
            rac.getAuthnContextClassRefs().addAll(classRefPrincipals.stream().map(AuthnContextClassRefPrincipal::getAuthnContextClassRef).collect(Collectors.toUnmodifiableList()));
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Setting RequestedAuthnContext class refs to {}", (Object)this.getLogPrefix(), classRefPrincipals.stream().map(AuthnContextClassRefPrincipal::getName).collect(Collectors.toUnmodifiableList()));
            }
            return rac;
        }
        List declRefPrincipals = principals.stream().filter(AuthnContextDeclRefPrincipal.class::isInstance).map(AuthnContextDeclRefPrincipal.class::cast).collect(Collectors.toUnmodifiableList());
        if (!declRefPrincipals.isEmpty()) {
            RequestedAuthnContext rac = (RequestedAuthnContext)builder.buildObject();
            rac.getAuthnContextDeclRefs().addAll(declRefPrincipals.stream().map(AuthnContextDeclRefPrincipal::getAuthnContextDeclRef).collect(Collectors.toUnmodifiableList()));
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Setting RequestedAuthnContext decl refs to {}", (Object)this.getLogPrefix(), declRefPrincipals.stream().map(AuthnContextDeclRefPrincipal::getName).collect(Collectors.toUnmodifiableList()));
            }
            return rac;
        }
        return null;
    }

    @Nullable
    public Scoping buildScoping(@Nonnull ProfileRequestContext profileRequestContext, @Nullable Integer count, @Nonnull @NonnullElements Set<String> idplist) {
        if (count == null && idplist.isEmpty()) {
            return null;
        }
        if (this.profileConfiguration.isIgnoreScoping(profileRequestContext)) {
            this.log.warn("{} Skipping generation of Scoping element in violation of standard", (Object)this.getLogPrefix());
            return null;
        }
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder scopingBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(Scoping.DEFAULT_ELEMENT_NAME);
        Scoping scoping = (Scoping)scopingBuilder.buildObject();
        scoping.setProxyCount(Integer.valueOf(Integer.min(0, count - 1)));
        if (!idplist.isEmpty()) {
            SAMLObjectBuilder idpListBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(IDPList.DEFAULT_ELEMENT_NAME);
            SAMLObjectBuilder idpBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(IDPEntry.DEFAULT_ELEMENT_NAME);
            IDPList idps = (IDPList)idpListBuilder.buildObject();
            for (String idp : idplist) {
                IDPEntry entry = (IDPEntry)idpBuilder.buildObject();
                entry.setProviderID(idp);
                idps.getIDPEntrys().add(entry);
            }
            scoping.setIDPList(idps);
        }
        return scoping;
    }
}

