/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.config.navigate.IdentifierGenerationStrategyLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.DelegatedAssertionLookupStrategy;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
public class AddAuthnStatementToAssertionFromInboundAssertionToken
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAuthnStatementToAssertionFromInboundAssertionToken.class);
    private boolean statementInOwnAssertion = false;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = new IdentifierGenerationStrategyLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new ResponderIdLookupFunction();
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private String issuerId;
    @NonnullAfterInit
    private Function<ProfileRequestContext, Assertion> assertionLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Assertion> assertionTokenStrategy = new DelegatedAssertionLookupStrategy();
    @Nullable
    private AuthnStatement sourceStatement;

    public boolean isStatementInOwnAssertion() {
        return this.statementInOwnAssertion;
    }

    public void setStatementInOwnAssertion(boolean inOwnAssertion) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.statementInOwnAssertion = inOwnAssertion;
    }

    public void setAssertionTokenStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionTokenStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion token strategy may not be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @Nonnull
    public IdentifierGenerationStrategy getIdGenerator() {
        Constraint.isNotNull((Object)this.idGenerator, (String)"IdentifierGenerationStrategy has not been initialized yet");
        return this.idGenerator;
    }

    @Nonnull
    public String getIssuerId() {
        Constraint.isNotNull((Object)this.issuerId, (String)"Issuer name has not been initialized yet");
        return this.issuerId;
    }

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.assertionLookupStrategy == null) {
            this.assertionLookupStrategy = new AssertionStrategy();
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.log.debug("{} Attempting to add an AuthnStatement to outgoing Assertion based on inbound Assertion token", (Object)this.getLogPrefix());
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No assertion issuer value", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Assertion attestedToken = this.assertionTokenStrategy.apply(profileRequestContext);
        if (attestedToken == null) {
            this.log.debug("{} No inbound assertion token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (!attestedToken.getAuthnStatements().isEmpty()) {
            this.sourceStatement = (AuthnStatement)attestedToken.getAuthnStatements().get(0);
        }
        if (this.sourceStatement == null) {
            this.log.debug("{} Inbound assertion token contains no AuthnStatement", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Assertion assertion = this.assertionLookupStrategy.apply(profileRequestContext);
        if (assertion == null) {
            this.log.error("Unable to obtain Assertion to modify");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        AuthnStatement statement = this.getNewAuthnStatement();
        if (statement == null) {
            this.log.error("Unable to obtain AuthnStatement to add");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return;
        }
        assertion.getAuthnStatements().add(statement);
        this.log.debug("{} Added AuthenticationStatement to Assertion {}", (Object)this.getLogPrefix(), (Object)assertion.getID());
    }

    @Nullable
    protected AuthnStatement getNewAuthnStatement() {
        try {
            return (AuthnStatement)XMLObjectSupport.cloneXMLObject((XMLObject)this.sourceStatement);
        }
        catch (MarshallingException | UnmarshallingException e) {
            this.log.error("{} Error cloning Assertion AuthnStatement", (Object)this.getLogPrefix(), (Object)e);
            return null;
        }
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, Assertion> {
        private AssertionStrategy() {
        }

        @Override
        @Nullable
        public Assertion apply(@Nullable ProfileRequestContext input) {
            if (input != null && input.getOutboundMessageContext() != null) {
                Object outboundMessage = input.getOutboundMessageContext().getMessage();
                if (outboundMessage == null) {
                    Assertion ret = SAML2ActionSupport.buildAssertion((org.opensaml.profile.action.AbstractProfileAction)AddAuthnStatementToAssertionFromInboundAssertionToken.this, (IdentifierGenerationStrategy)AddAuthnStatementToAssertionFromInboundAssertionToken.this.getIdGenerator(), (String)AddAuthnStatementToAssertionFromInboundAssertionToken.this.getIssuerId());
                    input.getOutboundMessageContext().setMessage((Object)ret);
                    return ret;
                }
                if (outboundMessage instanceof Assertion) {
                    return (Assertion)outboundMessage;
                }
                if (outboundMessage instanceof Response) {
                    if (AddAuthnStatementToAssertionFromInboundAssertionToken.this.isStatementInOwnAssertion() || ((Response)outboundMessage).getAssertions().isEmpty()) {
                        return SAML2ActionSupport.addAssertionToResponse((org.opensaml.profile.action.AbstractProfileAction)AddAuthnStatementToAssertionFromInboundAssertionToken.this, (Response)((Response)outboundMessage), (IdentifierGenerationStrategy)AddAuthnStatementToAssertionFromInboundAssertionToken.this.getIdGenerator(), (String)AddAuthnStatementToAssertionFromInboundAssertionToken.this.getIssuerId());
                    }
                    return (Assertion)((Response)outboundMessage).getAssertions().get(0);
                }
            }
            return null;
        }
    }
}

