/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.saml.profile.impl.BaseAddAttributeStatementToAssertion;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.profile.SAML1ActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAttributeStatementToAssertion
extends BaseAddAttributeStatementToAssertion<Attribute> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAttributeStatementToAssertion.class);
    @Nonnull
    private Function<ProfileRequestContext, Assertion> assertionLookupStrategy = new AssertionStrategy();

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            AttributeStatement statement = this.buildAttributeStatement(profileRequestContext, this.getAttributeContext().getIdPAttributes().values());
            if (statement == null) {
                this.log.debug("{} No AttributeStatement was built, nothing to do", (Object)this.getLogPrefix());
                return;
            }
            Assertion assertion = this.assertionLookupStrategy.apply(profileRequestContext);
            if (assertion == null) {
                this.log.error("Unable to obtain Assertion to modify");
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
                return;
            }
            assertion.getAttributeStatements().add(statement);
            this.log.debug("{} Adding constructed AttributeStatement to Assertion {} ", (Object)this.getLogPrefix(), (Object)assertion.getID());
        }
        catch (AttributeEncodingException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncodeAttribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AttributeStatement buildAttributeStatement(@Nonnull ProfileRequestContext profileRequestContext, @Nullable @NullableElements Collection<IdPAttribute> attributes) throws AttributeEncodingException {
        if (attributes == null || attributes.isEmpty()) {
            this.log.debug("{} No attributes available to be encoded, nothing to do", (Object)this.getLogPrefix());
            return null;
        }
        ArrayList<Attribute> encodedAttributes = new ArrayList<Attribute>(attributes.size());
        ServiceableComponent component = null;
        try {
            component = this.getTranscoderRegistry().getServiceableComponent();
            if (component == null) {
                throw new AttributeEncodingException("Attribute transoding service unavailable");
            }
            for (IdPAttribute attribute : attributes) {
                if (attribute == null || attribute.getValues().isEmpty()) continue;
                this.encodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, attribute, encodedAttributes);
            }
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
        if (encodedAttributes.isEmpty()) {
            this.log.debug("{} No attributes were encoded as SAML 1 Attributes, nothing to do", (Object)this.getLogPrefix());
            return null;
        }
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement statement = (AttributeStatement)statementBuilder.buildObject();
        statement.getAttributes().addAll(encodedAttributes);
        return statement;
    }

    private void encodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull @NonnullElements Collection<Attribute> results) throws AttributeEncodingException {
        this.log.debug("{} Attempting to encode attribute {} as a SAML 1 Attribute", (Object)this.getLogPrefix(), (Object)attribute.getId());
        if (super.encodeAttribute(registry, profileRequestContext, attribute, Attribute.class, results) == 0) {
            this.log.debug("{} Attribute {} did not have SAML 1 Attribute transcoder instructions associated, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
        }
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, Assertion> {
        private AssertionStrategy() {
        }

        @Override
        @Nullable
        public Assertion apply(@Nullable ProfileRequestContext input) {
            if (input != null && input.getOutboundMessageContext() != null) {
                Object outboundMessage = input.getOutboundMessageContext().getMessage();
                if (outboundMessage == null) {
                    Assertion ret = SAML1ActionSupport.buildAssertion((AbstractProfileAction)AddAttributeStatementToAssertion.this, (IdentifierGenerationStrategy)AddAttributeStatementToAssertion.this.getIdGenerator(), (String)AddAttributeStatementToAssertion.this.getIssuerId());
                    input.getOutboundMessageContext().setMessage((Object)ret);
                    return ret;
                }
                if (outboundMessage instanceof Assertion) {
                    return (Assertion)outboundMessage;
                }
                if (outboundMessage instanceof Response) {
                    if (AddAttributeStatementToAssertion.this.isStatementInOwnAssertion() || ((Response)outboundMessage).getAssertions().isEmpty()) {
                        return SAML1ActionSupport.addAssertionToResponse((AbstractProfileAction)AddAttributeStatementToAssertion.this, (Response)((Response)outboundMessage), (IdentifierGenerationStrategy)AddAttributeStatementToAssertion.this.getIdGenerator(), (String)AddAttributeStatementToAssertion.this.getIssuerId());
                    }
                    return (Assertion)((Response)outboundMessage).getAssertions().get(0);
                }
            }
            return null;
        }
    }
}

