/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.relyingparty.impl;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.logic.RelyingPartyIdPredicate;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.idp.saml.profile.logic.MappedEntityAttributesPredicate;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.StrategyIndirectedPredicate;
import org.opensaml.saml.common.messaging.context.navigate.EntityDescriptorLookupFunction;
import org.opensaml.saml.common.profile.logic.EntityAttributesPredicate;
import org.opensaml.saml.common.profile.logic.EntityGroupNamePredicate;
import org.opensaml.saml.metadata.resolver.MetadataResolver;

public final class RelyingPartyConfigurationSupport {
    private RelyingPartyConfigurationSupport() {
    }

    @Nonnull
    public static RelyingPartyConfiguration byName(@Nonnull @NonnullElements Collection<String> relyingPartyIds) {
        Constraint.isNotNull(relyingPartyIds, (String)"Relying Party ID list cannot be null");
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setActivationCondition((Predicate)new RelyingPartyIdPredicate(relyingPartyIds));
        StringBuffer name = new StringBuffer("EntityNames[");
        for (String rpId : relyingPartyIds) {
            name.append(rpId).append(',');
        }
        name.append(']');
        config.setId(name.toString());
        return config;
    }

    @Nonnull
    public static RelyingPartyConfiguration byGroup(@Nonnull @NonnullElements Collection<String> groupNames, @Nullable MetadataResolver resolver) {
        Constraint.isNotNull(groupNames, (String)"Group name list cannot be null");
        StrategyIndirectedPredicate indirectPredicate = new StrategyIndirectedPredicate(new EntityDescriptorLookupFunction().compose((Function)new SAMLMetadataContextLookupFunction()), (Predicate)new EntityGroupNamePredicate(groupNames, resolver));
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setActivationCondition((Predicate)indirectPredicate);
        StringBuffer name = new StringBuffer("EntityGroups[");
        for (String group : groupNames) {
            name.append(group).append(',');
        }
        name.append(']');
        config.setId(name.toString());
        return config;
    }

    @Nonnull
    public static RelyingPartyConfiguration byTag(@Nonnull @NonnullElements Collection<EntityAttributesPredicate.Candidate> candidates, boolean trim, boolean matchAll) {
        Constraint.isNotNull(candidates, (String)"Candidate list cannot be null");
        StrategyIndirectedPredicate indirectPredicate = new StrategyIndirectedPredicate(new EntityDescriptorLookupFunction().compose((Function)new SAMLMetadataContextLookupFunction()), (Predicate)new EntityAttributesPredicate(candidates, trim, matchAll));
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setActivationCondition((Predicate)indirectPredicate);
        return config;
    }

    @Nonnull
    public static RelyingPartyConfiguration byMappedTag(@Nonnull @NonnullElements Collection<EntityAttributesPredicate.Candidate> candidates, boolean trim, boolean matchAll) {
        Constraint.isNotNull(candidates, (String)"Candidate list cannot be null");
        StrategyIndirectedPredicate indirectPredicate = new StrategyIndirectedPredicate(new EntityDescriptorLookupFunction().compose((Function)new SAMLMetadataContextLookupFunction()), (Predicate)new MappedEntityAttributesPredicate(candidates, trim, matchAll));
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setActivationCondition((Predicate)indirectPredicate);
        return config;
    }
}

