/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.config.navigate.IdentifierGenerationStrategyLookupFunction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAddAttributeStatementToAssertion<T extends SAMLObject>
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseAddAttributeStatementToAssertion.class);
    private boolean statementInOwnAssertion = false;
    private boolean ignoringUnencodableAttributes = true;
    @NonnullAfterInit
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @Nullable
    private AttributeContext attributeCtx;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private String issuerId;

    public BaseAddAttributeStatementToAssertion() {
        this.idGeneratorLookupStrategy = new IdentifierGenerationStrategyLookupFunction();
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
    }

    public boolean isStatementInOwnAssertion() {
        return this.statementInOwnAssertion;
    }

    public void setStatementInOwnAssertion(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.statementInOwnAssertion = flag;
    }

    public boolean isIgnoringUnencodableAttributes() {
        return this.ignoringUnencodableAttributes;
    }

    public void setIgnoringUnencodableAttributes(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ignoringUnencodableAttributes = flag;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @NonnullAfterInit
    public ReloadableService<AttributeTranscoderRegistry> getTranscoderRegistry() {
        return this.transcoderRegistry;
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    @Nonnull
    public AttributeContext getAttributeContext() {
        Constraint.isNotNull((Object)this.attributeCtx, (String)"AttributeContext has not been initialized yet");
        return this.attributeCtx;
    }

    @Nonnull
    public IdentifierGenerationStrategy getIdGenerator() {
        Constraint.isNotNull((Object)this.idGenerator, (String)"IdentifierGenerationStrategy has not been initialized yet");
        return this.idGenerator;
    }

    @Nonnull
    @NotEmpty
    public String getIssuerId() {
        Constraint.isNotNull((Object)this.issuerId, (String)"Issuer name has not been initialized yet");
        return this.issuerId;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.log.debug("{} Attempting to add an AttributeStatement to outgoing Assertion", (Object)this.getLogPrefix());
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No assertion issuer value", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeCtx == null) {
            this.log.debug("{} No AttributeSubcontext available, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected int encodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull Class<T> to, @Nonnull @NonnullElements @Live Collection<T> results) throws AttributeEncodingException {
        Collection transcodingRules = registry.getTranscodingRules(attribute, to);
        if (transcodingRules.isEmpty()) {
            this.log.debug("{} Attribute {} does not have any transcoding rules, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return 0;
        }
        int count = 0;
        for (TranscodingRule rules : transcodingRules) {
            try {
                AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rules);
                SAMLObject encodedAttribute = (SAMLObject)transcoder.encode(profileRequestContext, attribute, to, rules);
                if (encodedAttribute == null) continue;
                results.add(encodedAttribute);
                ++count;
            }
            catch (AttributeEncodingException e) {
                if (this.isIgnoringUnencodableAttributes()) {
                    this.log.debug("{} Unable to encode attribute {}", new Object[]{this.getLogPrefix(), attribute.getId(), e});
                    continue;
                }
                throw e;
            }
        }
        return count;
    }
}

