/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.metadata.resolver.filter.impl.ByReferenceMetadataFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ByReferenceMetadataFilterBridge
implements MetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ByReferenceMetadataFilterBridge.class);
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private MetadataFilterChain filterChain;

    public void setApplicationContext(@Nullable ApplicationContext context) {
        this.applicationContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        MetadataFilterChain chain = null;
        ByReferenceMetadataFilterBridge byReferenceMetadataFilterBridge = this;
        synchronized (byReferenceMetadataFilterBridge) {
            if (this.filterChain != null) {
                chain = this.filterChain;
            } else if (this.applicationContext != null) {
                try {
                    Map beans = this.applicationContext.getBeansOfType(ByReferenceMetadataFilter.class);
                    this.log.debug("Bridging to {} ByReference filters in Spring context", (Object)beans.size());
                    this.filterChain = new MetadataFilterChain();
                    this.filterChain.setFilters(List.copyOf(beans.values()));
                    chain = this.filterChain;
                }
                catch (BeansException e) {
                    throw new FilterException((Exception)((Object)e));
                }
            } else {
                throw new FilterException("ApplicationContext is not set");
            }
        }
        return chain != null ? chain.filter(metadata, context) : metadata;
    }
}

