/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;

public class EncryptionAlgorithmAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy = new ChildContextLookup(EncryptionContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        EncryptionContext encryptionCtx = this.encryptionContextLookupStrategy.apply(input);
        if (encryptionCtx != null) {
            if (encryptionCtx.getAssertionEncryptionParameters() != null) {
                return encryptionCtx.getAssertionEncryptionParameters().getDataEncryptionAlgorithm();
            }
            if (encryptionCtx.getAttributeEncryptionParameters() != null) {
                return encryptionCtx.getAttributeEncryptionParameters().getDataEncryptionAlgorithm();
            }
            if (encryptionCtx.getIdentifierEncryptionParameters() != null) {
                return encryptionCtx.getIdentifierEncryptionParameters().getDataEncryptionAlgorithm();
            }
        }
        return null;
    }
}

