/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAMLEncoderSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2XMLObjectAttributeTranscoder
extends AbstractSAML2AttributeTranscoder<XMLObjectAttributeValue> {
    @Nonnull
    @NotEmpty
    public static final String PROP_INCLUDE_ATTR_VALUE = "saml2.includeAttributeValue";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2XMLObjectAttributeTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof XMLObjectAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull XMLObjectAttributeValue value) throws AttributeEncodingException {
        return SAMLEncoderSupport.encodeXMLObjectValue((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (XMLObject)value.getValue());
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nullable XMLObject value) {
        if (value == null) {
            return null;
        }
        Boolean includeAttributeValue = (Boolean)rule.getOrDefault(PROP_INCLUDE_ATTR_VALUE, Boolean.class, (Object)Boolean.FALSE);
        if (includeAttributeValue.booleanValue()) {
            return new XMLObjectAttributeValue(value);
        }
        List children = value.getOrderedChildren();
        if (null == children || children.isEmpty()) {
            this.log.debug("Ignoring XMLObject with no child elements");
            return null;
        }
        if (children.size() > 1) {
            this.log.debug("XMLObject has more than one child, returning first element only");
        }
        XMLObject child = (XMLObject)children.get(0);
        this.log.debug("Returning value of type {}", (Object)child.getClass().getSimpleName());
        return new XMLObjectAttributeValue(child);
    }
}

