/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAMLEncoderSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2StringAttributeTranscoder
extends AbstractSAML2AttributeTranscoder<StringAttributeValue> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2StringAttributeTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof StringAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull StringAttributeValue value) throws AttributeEncodingException {
        if (value instanceof ScopedStringAttributeValue) {
            this.log.warn("Attribute '{}': Lossy encoding of attribute value of type {} to SAML2 String Attribute", (Object)attribute.getId(), (Object)value.getClass().getSimpleName());
        }
        Boolean encodeType = (Boolean)rule.getOrDefault("saml2.encodeType", Boolean.class, (Object)Boolean.TRUE);
        return SAMLEncoderSupport.encodeStringValue((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (String)value.getValue(), (boolean)encodeType);
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nullable XMLObject value) {
        return value != null ? StringAttributeValue.valueOf((String)this.getStringValue(value)) : null;
    }
}

