/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareInboundMessageContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrepareInboundMessageContext.class);
    @Nonnull
    private Function<ProfileRequestContext, LogoutPropagationContext> logoutPropContextLookupStrategy = new ChildContextLookup(LogoutPropagationContext.class);
    @Nullable
    private SAML2SPSession saml2Session;

    public void setLogoutPropagationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutPropagationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logoutPropContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutPropagationContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        LogoutPropagationContext logoutPropCtx = (LogoutPropagationContext)this.logoutPropContextLookupStrategy.apply((Object)profileRequestContext);
        if (logoutPropCtx == null) {
            this.log.debug("{} No logout propagation context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (logoutPropCtx.getSession() == null || !(logoutPropCtx.getSession() instanceof SAML2SPSession)) {
            this.log.debug("{} Logout propgation context did not contain a SAML2SPSession", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.saml2Session = (SAML2SPSession)logoutPropCtx.getSession();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = new MessageContext();
        profileRequestContext.setInboundMessageContext(msgCtx);
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)msgCtx.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setEntityId(this.saml2Session.getId());
        this.log.debug("{} Initialized inbound message context for logout of {}", (Object)this.getLogPrefix(), (Object)this.saml2Session.getId());
    }
}

