/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLPresenterEntityContext;
import org.opensaml.saml.ext.saml2delrestrict.Delegate;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDelegationRestrictionToAssertions
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddDelegationRestrictionToAssertions.class);
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy = Functions.compose((Function)new MessageLookup(Response.class), (Function)new OutboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, SAMLPresenterEntityContext> presenterContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLPresenterEntityContext.class), (Function)new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, LibertySSOSContext> libertyContextLookupStrategy = new ChildContextLookup(LibertySSOSContext.class);
    @Nullable
    private List<Assertion> assertions;
    @Nullable
    private Assertion attestedAssertion;
    @Nullable
    private String attestedSubjectConfirmationMethod;
    @Nullable
    private String presenterEntityID;
    @Nullable
    private DateTime delegationInstant;

    public void setLibertyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LibertySSOSContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.libertyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion token strategy may not be null");
    }

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public void setPresenterLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLPresenterEntityContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.presenterContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        Response response = (Response)this.responseLookupStrategy.apply((Object)profileRequestContext);
        if (response == null) {
            this.log.debug("{} No SAML Response located in current profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.assertions = response.getAssertions();
        if (this.assertions.isEmpty()) {
            this.log.debug("{} No assertions to modify", (Object)this.getLogPrefix());
            return false;
        }
        this.log.debug("{} Attempting to add a DelegationRestrictionType Condition to {} Assertion(s) in Response", (Object)this.getLogPrefix(), (Object)this.assertions.size());
        SAMLPresenterEntityContext presenterContext = (SAMLPresenterEntityContext)this.presenterContextLookupStrategy.apply((Object)profileRequestContext);
        if (presenterContext == null || presenterContext.getEntityId() == null) {
            this.log.debug("{} No SAML presenter entityID", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.presenterEntityID = presenterContext.getEntityId();
        LibertySSOSContext libertyContext = (LibertySSOSContext)this.libertyContextLookupStrategy.apply((Object)profileRequestContext);
        if (libertyContext == null) {
            this.log.debug("{} No LibertySSOSContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.attestedAssertion = libertyContext.getAttestedToken();
        if (this.attestedAssertion == null) {
            this.log.debug("{} No attested SAML 2 Assertion", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.attestedSubjectConfirmationMethod = libertyContext.getAttestedSubjectConfirmationMethod();
        if (this.attestedSubjectConfirmationMethod == null) {
            this.log.debug("{} No attested SAML 2 SubjectConfirmation method", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.delegationInstant = new DateTime();
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        for (Assertion assertion : this.assertions) {
            this.addDelegationRestriction(profileRequestContext, SAML2ActionSupport.addConditionsToAssertion((org.opensaml.profile.action.AbstractProfileAction)this, (Assertion)assertion));
            this.log.debug("{} Added DelegationRestrictionType Condition to Assertion {}", (Object)this.getLogPrefix(), (Object)assertion.getID());
        }
    }

    protected void addDelegationRestriction(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull Conditions conditions) {
        DelegationRestrictionType drt = this.buildDelegationRestriction(profileRequestContext);
        if (drt != null) {
            conditions.getConditions().add(drt);
        } else {
            this.log.error("{} Unable to build DelegationRestriction Condition", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
        }
    }

    @Nullable
    protected DelegationRestrictionType buildDelegationRestriction(@Nonnull ProfileRequestContext profileRequestContext) {
        DelegationRestrictionType drt = null;
        Delegate newDelegate = this.buildDelegate(profileRequestContext);
        drt = this.getDelegationRestrictionCondition(this.attestedAssertion.getConditions());
        if (drt != null) {
            try {
                drt = (DelegationRestrictionType)XMLObjectSupport.cloneXMLObject((XMLObject)drt);
            }
            catch (MarshallingException | UnmarshallingException e) {
                this.log.error("{} Error cloning DelegationRestriction Condition", (Object)this.getLogPrefix(), (Object)e);
                return null;
            }
        } else {
            drt = (DelegationRestrictionType)XMLObjectSupport.getBuilder((QName)DelegationRestrictionType.TYPE_NAME).buildObject(Condition.DEFAULT_ELEMENT_NAME, DelegationRestrictionType.TYPE_NAME);
        }
        drt.getDelegates().add(newDelegate);
        return drt;
    }

    @Nullable
    protected DelegationRestrictionType getDelegationRestrictionCondition(@Nullable Conditions conditions) {
        if (conditions == null) {
            return null;
        }
        for (Condition conditionChild : conditions.getConditions()) {
            if (!DelegationRestrictionType.TYPE_NAME.equals(conditionChild.getSchemaType())) continue;
            if (conditionChild instanceof DelegationRestrictionType) {
                return (DelegationRestrictionType)conditionChild;
            }
            this.log.warn("Saw Condition of xsi:type DelegationRestrictionType, but incorrect class instance: {}", (Object)conditionChild.getClass().getName());
        }
        return null;
    }

    @Nonnull
    protected Delegate buildDelegate(@Nonnull ProfileRequestContext profileRequestContext) {
        NameID delegateNameID = (NameID)XMLObjectSupport.buildXMLObject((QName)NameID.DEFAULT_ELEMENT_NAME);
        delegateNameID.setValue(this.presenterEntityID);
        delegateNameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        Delegate newDelegate = (Delegate)XMLObjectSupport.buildXMLObject((QName)Delegate.DEFAULT_ELEMENT_NAME);
        newDelegate.setNameID(delegateNameID);
        newDelegate.setConfirmationMethod(this.attestedSubjectConfirmationMethod);
        newDelegate.setDelegationInstant(this.delegationInstant);
        return newDelegate;
    }
}

