/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.profile.config.logic.ForceAuthnProfileConfigPredicate;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeAuthenticationContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeAuthenticationContext.class);
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate = new ForceAuthnProfileConfigPredicate();
    @Nonnull
    private Function<ProfileRequestContext, AuthnRequest> requestLookupStrategy = Functions.compose((Function)new MessageLookup(AuthnRequest.class), (Function)new InboundMessageContextLookup());
    @Nullable
    private AuthnRequest authnRequest;

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.authnRequest = (AuthnRequest)this.requestLookupStrategy.apply((Object)profileRequestContext);
        if (this.authnRequest == null) {
            this.log.debug("{} No inbound AuthnRequest, passive flag will be off", (Object)this.getLogPrefix());
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AuthenticationContext initialAuthnContext;
        AuthenticationContext authnCtx = new AuthenticationContext();
        if (this.authnRequest != null) {
            authnCtx.setForceAuthn(this.authnRequest.isForceAuthn().booleanValue());
            authnCtx.setIsPassive(this.authnRequest.isPassive().booleanValue());
        }
        if ((initialAuthnContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class)) != null) {
            authnCtx.setInitialAuthenticationResult(initialAuthnContext.getAuthenticationResult());
        }
        if (!authnCtx.isForceAuthn()) {
            authnCtx.setForceAuthn(this.forceAuthnPredicate.apply((Object)profileRequestContext));
        }
        profileRequestContext.addSubcontext((BaseContext)authnCtx, true);
        this.log.debug("{} Created authentication context: {}", (Object)this.getLogPrefix(), (Object)authnCtx);
    }
}

