/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.NameIdentifierGenerationService;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.profile.SAML1NameIdentifierGenerator;

public class ProxySAML1NameIdentifierGenerator
implements SAML1NameIdentifierGenerator {
    @Nonnull
    private final ReloadableService<NameIdentifierGenerationService> generatorService;

    public ProxySAML1NameIdentifierGenerator(@Nonnull ReloadableService<NameIdentifierGenerationService> service) {
        this.generatorService = (ReloadableService)Constraint.isNotNull(service, (String)"NameIdentifierGenerationService cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NameIdentifier generate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String format) throws SAMLException {
        ServiceableComponent component = null;
        try {
            component = this.generatorService.getServiceableComponent();
            if (component == null) {
                throw new SAMLException("Invalid NameIdentifierGenerationService configuration");
            }
            NameIdentifier nameIdentifier = ((NameIdentifierGenerationService)component.getComponent()).getSAML1NameIdentifierGenerator().generate(profileRequestContext, format);
            return nameIdentifier;
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }
}

