/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.idp.saml.nameid.impl.PersistentIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml2.profile.AbstractSAML2NameIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class PersistentSAML2NameIDGenerator
extends AbstractSAML2NameIDGenerator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PersistentSAML2NameIDGenerator.class);
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> attributeSourceIds;
    @NonnullAfterInit
    private PersistentIdGenerationStrategy persistentIdStrategy;
    private boolean useUnfilteredAttributes;

    public PersistentSAML2NameIDGenerator() {
        this.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        this.subjectContextLookupStrategy = new ChildContextLookup(SubjectContext.class);
        this.attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
        this.attributeSourceIds = Collections.emptyList();
        this.setDefaultIdPNameQualifierLookupStrategy((Function)new ResponderIdLookupFunction());
        this.setDefaultSPNameQualifierLookupStrategy((Function)new RelyingPartyIdLookupFunction());
        this.useUnfilteredAttributes = true;
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.subjectContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setAttributeSourceIds(@Nonnull @NonnullElements List<String> ids) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(ids, (String)"Attribute ID collection cannot be null");
        this.attributeSourceIds = new ArrayList<String>(Collections2.filter(ids, (Predicate)Predicates.notNull()));
    }

    public void setPersistentIdGenerator(@Nonnull PersistentIdGenerationStrategy strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.persistentIdStrategy = (PersistentIdGenerationStrategy)Constraint.isNotNull((Object)strategy, (String)"PersistentIdGenerationStrategy cannot be null");
    }

    public void setUseUnfilteredAttributes(boolean flag) {
        this.useUnfilteredAttributes = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.persistentIdStrategy == null) {
            throw new ComponentInitializationException("PersistentIdGenerationStrategy cannot be null");
        }
        if (this.attributeSourceIds.isEmpty()) {
            throw new ComponentInitializationException("Attribute source ID list cannot be empty");
        }
    }

    @Nullable
    protected String getIdentifier(@Nonnull ProfileRequestContext profileRequestContext) throws SAMLException {
        String responderId;
        Function lookup = this.getDefaultIdPNameQualifierLookupStrategy();
        String string = responderId = lookup != null ? (String)lookup.apply((Object)profileRequestContext) : null;
        if (responderId == null) {
            this.log.debug("No responder identifier, can't generate persistent ID");
            return null;
        }
        String relyingPartyId = this.getEffectiveSPNameQualifier(profileRequestContext);
        if (relyingPartyId == null) {
            lookup = this.getDefaultSPNameQualifierLookupStrategy();
            String string2 = relyingPartyId = lookup != null ? (String)lookup.apply((Object)profileRequestContext) : null;
        }
        if (relyingPartyId == null) {
            this.log.debug("No relying party identifier, can't generate persistent ID");
            return null;
        }
        SubjectContext subjectCtx = (SubjectContext)this.subjectContextLookupStrategy.apply((Object)profileRequestContext);
        if (subjectCtx == null || subjectCtx.getPrincipalName() == null) {
            this.log.debug("No principal name, can't generate persistent ID");
            return null;
        }
        AttributeContext attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (attributeCtx == null) {
            this.log.debug("No attribute context, can't generate persistent ID");
            return null;
        }
        Map attributes = this.useUnfilteredAttributes ? attributeCtx.getUnfilteredIdPAttributes() : attributeCtx.getIdPAttributes();
        for (String sourceId : this.attributeSourceIds) {
            this.log.debug("Checking for source attribute {}", (Object)sourceId);
            IdPAttribute attribute = (IdPAttribute)attributes.get(sourceId);
            if (attribute == null) continue;
            List values = attribute.getValues();
            for (IdPAttributeValue value : values) {
                if (value instanceof ScopedStringAttributeValue) {
                    this.log.debug("Generating persistent NameID from Scoped String-valued attribute {}", (Object)sourceId);
                    return this.persistentIdStrategy.generate(responderId, relyingPartyId, subjectCtx.getPrincipalName(), ((ScopedStringAttributeValue)value).getValue() + '@' + ((ScopedStringAttributeValue)value).getScope());
                }
                if (value instanceof StringAttributeValue) {
                    if (StringSupport.trimOrNull((String)((String)value.getValue())) == null) {
                        this.log.debug("Skipping all-whitespace string value");
                        continue;
                    }
                    this.log.debug("Generating persistent NameID from String-valued attribute {}", (Object)sourceId);
                    return this.persistentIdStrategy.generate(responderId, relyingPartyId, subjectCtx.getPrincipalName(), (String)value.getValue());
                }
                this.log.info("Unrecognized attribute value type: {}", (Object)value.getClass().getName());
            }
        }
        this.log.info("Attribute sources {} did not produce a usable source identifier", this.attributeSourceIds);
        return null;
    }
}

