/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import com.google.common.base.Predicate;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.LegacyPrincipalDecoder;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.authn.principal.NameIdentifierPrincipal;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyCanonicalization
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LegacyCanonicalization.class);
    @Nonnull
    private final ReloadableService<AttributeResolver> attributeResolverService;

    public LegacyCanonicalization(@Nonnull @ParameterName(name="resolverService") ReloadableService<AttributeResolver> resolverService) {
        this.attributeResolverService = (ReloadableService)Constraint.isNotNull(resolverService, (String)"AttributeResolver cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        ServiceableComponent component = null;
        try {
            component = this.attributeResolverService.getServiceableComponent();
            if (null == component) {
                this.log.error("{} Error resolving PrincipalConnector: Invalid Attribute resolver configuration.", (Object)this.getLogPrefix());
                c14nContext.setException((Exception)new SubjectCanonicalizationException("Error resolving PrincipalConnectore: Invalid Attribute resolver configuration."));
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                return;
            }
            AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
            if (!(attributeResolver instanceof LegacyPrincipalDecoder)) {
                this.log.info("{} Attribute Resolver did not implement LegacyPrincipalDecoder.", (Object)this.getLogPrefix());
                c14nContext.setException((Exception)new SubjectCanonicalizationException("Attribute Resolver did not implement LegacyPrincipalDecoder."));
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                return;
            }
            LegacyPrincipalDecoder decoder = (LegacyPrincipalDecoder)attributeResolver;
            String decodedPrincipal = decoder.canonicalize(c14nContext);
            if (null == decodedPrincipal) {
                this.log.info("{} Legacy Principal Decoding returned no value", (Object)this.getLogPrefix());
                c14nContext.setException((Exception)new SubjectCanonicalizationException("Legacy Principal Decoding returned no value"));
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                return;
            }
            c14nContext.setPrincipalName(decodedPrincipal);
        }
        catch (ResolutionException e) {
            c14nContext.setException((Exception)((Object)e));
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SubjectCanonicalizationError");
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }

    public static SubjectCanonicalizationFlowDescriptor c14LegacyPrincipalConnectorFactory(@ParameterName(name="activationCondition") Predicate<ProfileRequestContext> activationCondition) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.BEAN, (String)"c14n/LegacyPrincipalConnector", (String)"c14n/subject-c14n.xml", (String)"<remove>");
        SubjectCanonicalizationFlowDescriptor result = new SubjectCanonicalizationFlowDescriptor();
        result.setActivationCondition(activationCondition);
        return result;
    }

    public static class ActivationCondition
    implements Predicate<ProfileRequestContext> {
        @Nullable
        private final ReloadableService<AttributeResolver> attributeResolverService;

        public ActivationCondition(@ParameterName(name="service") ReloadableService<AttributeResolver> service) {
            this.attributeResolverService = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(@Nullable ProfileRequestContext input) {
            if (null == input) {
                return false;
            }
            SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)input.getSubcontext(SubjectCanonicalizationContext.class);
            if (null == c14nContext) {
                return false;
            }
            Subject subject = c14nContext.getSubject();
            if (null == subject) {
                return false;
            }
            Set<NameIDPrincipal> nameIDs = subject.getPrincipals(NameIDPrincipal.class);
            Set<NameIdentifierPrincipal> nameIdentifiers = subject.getPrincipals(NameIdentifierPrincipal.class);
            if (1 != nameIDs.size() + nameIdentifiers.size()) {
                return false;
            }
            if (null == this.attributeResolverService) {
                return false;
            }
            ServiceableComponent component = null;
            try {
                component = this.attributeResolverService.getServiceableComponent();
                if (null == component) {
                    boolean bl = false;
                    return bl;
                }
                AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
                if (!(attributeResolver instanceof LegacyPrincipalDecoder)) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = ((LegacyPrincipalDecoder)attributeResolver).hasValidConnectors();
                return bl;
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
    }
}

