/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingRelyingPartyMetadataProvider
extends AbstractIdentifiableInitializableComponent
implements MetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadingRelyingPartyMetadataProvider.class);
    private final ReloadableService<MetadataResolver> service;

    public ReloadingRelyingPartyMetadataProvider(@Nonnull @ParameterName(name="resolverService") ReloadableService<MetadataResolver> resolverService) {
        this.service = (ReloadableService)Constraint.isNotNull(resolverService, (String)"MetadataResolver Service cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<EntityDescriptor> resolve(CriteriaSet criteria) throws ResolverException {
        block7: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("RelyingPartyMetadataProvider '{}': Error accessing underlying metadata source: Invalid configuration.", (Object)this.getId());
                    break block7;
                }
                MetadataResolver resolver = (MetadataResolver)component.getComponent();
                Iterable iterable = resolver.resolve((Object)criteria);
                return iterable;
            }
            catch (ResolverException e) {
                this.log.error("RelyingPartyMetadataProvider '{}': Error during resolution", (Object)this.getId(), (Object)e);
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EntityDescriptor resolveSingle(CriteriaSet criteria) throws ResolverException {
        block7: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("RelyingPartyMetadataProvider '{}': Error accessing underlying metadata source: Invalid configuration.", (Object)this.getId());
                    break block7;
                }
                MetadataResolver resolver = (MetadataResolver)component.getComponent();
                EntityDescriptor entityDescriptor = (EntityDescriptor)resolver.resolveSingle((Object)criteria);
                return entityDescriptor;
            }
            catch (ResolverException e) {
                this.log.error("RelyingPartyResolver '{}': Error during resolution", (Object)this.getId(), (Object)e);
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequireValidMetadata() {
        block5: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("RelyingPartyMetadataProvider '{}': Error accessing underlying metadata source: Invalid configuration.", (Object)this.getId());
                    break block5;
                }
                MetadataResolver resolver = (MetadataResolver)component.getComponent();
                boolean bl = resolver.isRequireValidMetadata();
                return bl;
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        throw new IllegalAccessError("Could not find a valid MetadataResolver");
    }

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        throw new IllegalAccessError("Cannot set RequireValidMetadata");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataFilter getMetadataFilter() {
        block5: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("RelyingPartyMetadataProvider '{}': Error accessing underlying metadata source: Invalid configuration.", (Object)this.getId());
                    break block5;
                }
                MetadataResolver resolver = (MetadataResolver)component.getComponent();
                MetadataFilter metadataFilter = resolver.getMetadataFilter();
                return metadataFilter;
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        throw new IllegalAccessError("Could not find a valid MetadataResolver");
    }

    public void setMetadataFilter(MetadataFilter newFilter) {
        throw new IllegalAccessError("Cannot set Metadata filter");
    }
}

