/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnRequest;

public class IsPassiveAuditExtractor
implements Function<ProfileRequestContext, Boolean> {
    @Nonnull
    private final Function<ProfileRequestContext, AuthnRequest> requestLookupStrategy;

    public IsPassiveAuditExtractor(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    @Nullable
    public Boolean apply(@Nullable ProfileRequestContext input) {
        AuthnRequest request = (AuthnRequest)this.requestLookupStrategy.apply((Object)input);
        if (request != null) {
            return request.isPassive();
        }
        return null;
    }
}

