/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistentIdDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractPersistentIdDataConnector.class);
    @NonnullAfterInit
    private String generatedAttribute;
    @NonnullAfterInit
    private String sourceAttribute;
    @NonnullAfterInit
    private String sourceInformation;

    @Nullable
    @Deprecated
    public String getSourceAttributeId() {
        return this.sourceAttribute;
    }

    @Nullable
    @NonnullAfterInit
    public String getSourceAttributeInformation() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.sourceInformation;
    }

    public void setSourceAttributeId(@Nullable String newAttributeId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sourceAttribute = StringSupport.trimOrNull((String)newAttributeId);
    }

    @NonnullAfterInit
    public String getGeneratedAttributeId() {
        return this.generatedAttribute;
    }

    public void setGeneratedAttributeId(@Nullable String newAttributeId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.generatedAttribute = newAttributeId;
    }

    private void doDependencyInformation() throws ComponentInitializationException {
        StringBuilder dependencyInformation = new StringBuilder();
        boolean seenAttribute = false;
        for (ResolverPluginDependency depends : this.getDependencies()) {
            if (seenAttribute) {
                dependencyInformation.append(", ");
            }
            if (depends instanceof ResolverAttributeDefinitionDependency) {
                dependencyInformation.append(depends.getDependencyPluginId());
            } else if (depends instanceof ResolverDataConnectorDependency) {
                ResolverDataConnectorDependency dataConnectorDependency = (ResolverDataConnectorDependency)depends;
                if (dataConnectorDependency.isAllAttributes()) {
                    dependencyInformation.append(depends.getDependencyPluginId()).append("/*");
                } else {
                    if (dataConnectorDependency.getAttributeNames().isEmpty()) {
                        throw new ComponentInitializationException(this.getLogPrefix() + " No source attribute present.");
                    }
                    if (dataConnectorDependency.getAttributeNames().size() == 1) {
                        dependencyInformation.append(dataConnectorDependency.getDependencyPluginId()).append('/').append((String)dataConnectorDependency.getAttributeNames().iterator().next());
                    } else {
                        dependencyInformation.append(dataConnectorDependency.getDependencyPluginId()).append('/').append(dataConnectorDependency.getAttributeNames().toString());
                    }
                }
            } else {
                if (null == this.getSourceAttributeId()) {
                    throw new ComponentInitializationException(this.getLogPrefix() + " No source attribute present.");
                }
                dependencyInformation.append(depends.getDependencyPluginId()).append('/').append(this.getSourceAttributeId());
                depends.setDependencyAttributeId(this.getSourceAttributeId());
            }
            seenAttribute = true;
        }
        if (!seenAttribute) {
            if (null == this.getSourceAttributeId()) {
                throw new ComponentInitializationException(this.getLogPrefix() + " No source attribute present.");
            }
            this.log.warn("{} source Attribute {} present, but not declared as a dependency", (Object)this.getLogPrefix(), (Object)this.getSourceAttributeId());
            dependencyInformation.append(this.getSourceAttributeId());
        }
        this.sourceInformation = dependencyInformation.toString();
        this.log.debug("{} Source for definition: {}", (Object)this.getLogPrefix(), (Object)this.sourceInformation);
    }

    protected void doInitialize() throws ComponentInitializationException {
        this.doDependencyInformation();
        super.doInitialize();
        if (null == this.generatedAttribute) {
            this.generatedAttribute = this.getId();
            this.log.info("{} No generated attribute ID supplied, using ID of connector: {}", (Object)this.getLogPrefix(), (Object)this.generatedAttribute);
        }
    }

    @Nullable
    protected String resolveSourceAttribute(@Nonnull AttributeResolverWorkContext workContext) {
        IdPAttributeValue attributeValue;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        List attributeValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getDependencies(), (String)this.getId());
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("{} Source attribute {} for connector {} provide no values", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId()});
            return null;
        }
        if (attributeValues.size() > 1) {
            this.log.warn("{} Source attribute {} for connector {} has more than one value, only one value is used", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId()});
        }
        if ((attributeValue = (IdPAttributeValue)attributeValues.iterator().next()) instanceof StringAttributeValue) {
            if (StringSupport.trimOrNull((String)((String)attributeValue.getValue())) == null) {
                this.log.warn("{} Source attribute {} for connector {} was all-whitespace", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId()});
                return null;
            }
        } else {
            if (attributeValue instanceof EmptyAttributeValue) {
                EmptyAttributeValue emptyVal = (EmptyAttributeValue)attributeValue;
                this.log.warn("{} Source attribute {} value for connector {} was an empty value of type {}", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId(), emptyVal.getDisplayValue()});
                return null;
            }
            this.log.warn("{} Source attribute {} for connector {} was of an unsupported type: {}", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId(), attributeValue.getClass().getName()});
            return null;
        }
        String val = (String)attributeValue.getValue();
        if (val == null) {
            this.log.warn("{} Attribute value {} for connector {} resolved as empty or null", new Object[]{this.getLogPrefix(), this.getSourceAttributeInformation(), this.getId()});
        }
        return val;
    }

    @Nullable
    protected Map<String, IdPAttribute> encodeAsAttribute(@Nullable String value) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (null == value) {
            return null;
        }
        IdPAttribute attribute = new IdPAttribute(this.getGeneratedAttributeId());
        attribute.setValues(Collections.singletonList(StringAttributeValue.valueOf((String)value)));
        return Collections.singletonMap(this.getGeneratedAttributeId(), attribute);
    }
}

