/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.mapping.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.saml.attribute.mapping.AttributesMapper;
import net.shibboleth.idp.saml.attribute.mapping.impl.SAML1AttributeDesignatorsMapper;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.joda.time.DateTime;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SAML1AttributeDesignatorsMapperService
implements AttributesMapper<AttributeDesignator, IdPAttribute> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML1AttributeDesignatorsMapperService.class);
    @Nonnull
    private final ReloadableService<AttributeResolver> attributeResolverService;
    @Nonnull
    private boolean captiveServiceReloadFailed;
    @Nullable
    private SAML1AttributeDesignatorsMapper attributesMapper;
    @Nullable
    private DateTime lastReload;

    public SAML1AttributeDesignatorsMapperService(@Nonnull @ParameterName(name="resolverService") ReloadableService<AttributeResolver> resolverService) {
        this.attributeResolverService = (ReloadableService)Constraint.isNotNull(resolverService, (String)"AttributeResolver cannot be null");
    }

    @Nonnull
    @NonnullElements
    public Multimap<String, IdPAttribute> mapAttributes(@Nonnull @NonnullElements List<AttributeDesignator> prototypes) {
        SAML1AttributeDesignatorsMapper mapper = this.getMapper();
        if (null == mapper) {
            this.log.error("No AttributeMapper available, returning nothing");
            return ArrayListMultimap.create();
        }
        return mapper.mapAttributes(prototypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SAML1AttributeDesignatorsMapper getMapper() {
        if (this.lastReload != null && this.lastReload.equals((Object)this.attributeResolverService.getLastSuccessfulReloadInstant())) {
            return this.attributesMapper;
        }
        ServiceableComponent component = null;
        SAML1AttributeDesignatorsMapper am = null;
        try {
            DateTime when = this.attributeResolverService.getLastSuccessfulReloadInstant();
            component = this.attributeResolverService.getServiceableComponent();
            if (null == component) {
                if (!this.captiveServiceReloadFailed) {
                    this.log.error("Invalid AttributeResolver configuration");
                }
                this.captiveServiceReloadFailed = true;
            } else {
                AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
                am = new SAML1AttributeDesignatorsMapper(attributeResolver);
                this.captiveServiceReloadFailed = false;
                this.lastReload = when;
            }
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
        try {
            if (null != am) {
                am.initialize();
            }
        }
        catch (ComponentInitializationException e) {
            this.log.error("Error initializing AttributeMapper", (Throwable)e);
        }
        this.attributesMapper = am;
        return am;
    }
}

