/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.Type4UUIDIdentifierGenerationStrategy;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class BaseIdPInitiatedSSORequestMessageDecoder<RequestType>
extends AbstractHttpServletRequestMessageDecoder<RequestType> {
    @Nonnull
    @NotEmpty
    public static final String PROVIDER_ID_PARAM = "providerId";
    @Nonnull
    @NotEmpty
    public static final String SHIRE_PARAM = "shire";
    @Nonnull
    @NotEmpty
    public static final String TARGET_PARAM = "target";
    @Nonnull
    @NotEmpty
    public static final String TIME_PARAM = "time";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseIdPInitiatedSSORequestMessageDecoder.class);
    @Nonnull
    private final Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    @Nonnull
    private final IdentifierGenerationStrategy idGenerator = new Type4UUIDIdentifierGenerationStrategy();

    public void decode() throws MessageDecodingException {
        this.log.debug("Beginning to decode message from HttpServletRequest");
        super.decode();
        this.logDecodedMessage();
        this.log.debug("Successfully decoded message from HttpServletRequest.");
    }

    @Nonnull
    protected IdPInitiatedSSORequest buildIdPInitiatedSSORequest() throws MessageDecodingException {
        HttpServletRequest request = this.getHttpServletRequest();
        return new IdPInitiatedSSORequest(this.getEntityId(request), this.getAcsUrl(request), this.getTarget(request), this.getTime(request));
    }

    @Nonnull
    @NotEmpty
    protected String getEntityId(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String entityId = StringSupport.trimOrNull((String)request.getParameter(PROVIDER_ID_PARAM));
        if (entityId == null) {
            throw new MessageDecodingException("Shibboleth Authentication Request message did not contain the providerId query parameter.");
        }
        return entityId;
    }

    @Nullable
    protected String getAcsUrl(@Nonnull HttpServletRequest request) {
        return StringSupport.trimOrNull((String)request.getParameter(SHIRE_PARAM));
    }

    @Nullable
    protected String getTarget(@Nonnull HttpServletRequest request) {
        return StringSupport.trimOrNull((String)request.getParameter(TARGET_PARAM));
    }

    @Nullable
    protected Long getTime(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String timeString = StringSupport.trimOrNull((String)request.getParameter(TIME_PARAM));
        if (timeString == null) {
            return null;
        }
        try {
            long time = Long.parseLong(timeString);
            if (time < 0L) {
                throw new MessageDecodingException("Shibboleth Authentication Request contained a negative time value");
            }
            return time * 1000L;
        }
        catch (NumberFormatException e) {
            throw new MessageDecodingException("Shibboleth Authentication Request contained a non-numeric time value");
        }
    }

    protected void logDecodedMessage() {
        if (this.protocolMessageLog.isDebugEnabled()) {
            String message = this.getMessageToLog();
            if (message == null) {
                this.log.warn("Decoded message was null, nothing to log");
                return;
            }
            this.protocolMessageLog.debug("\n" + message);
        }
    }

    @Nonnull
    protected String getMessageID() {
        HttpServletRequest request = this.getHttpServletRequest();
        String timeString = StringSupport.trimOrNull((String)request.getParameter(TIME_PARAM));
        if (timeString != null) {
            String sessionID = request.getRequestedSessionId();
            if (sessionID != null) {
                return "_" + sessionID + '!' + timeString;
            }
            return this.idGenerator.generateIdentifier();
        }
        return this.idGenerator.generateIdentifier();
    }

    @Nullable
    protected abstract String getMessageToLog();
}

