/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.PersistentIdEntry;
import net.shibboleth.idp.saml.nameid.PersistentIdStore;
import net.shibboleth.idp.saml.nameid.impl.ComputedPersistentIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.PersistentIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPersistentIdGenerationStrategy
extends AbstractInitializableComponent
implements PersistentIdGenerationStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredPersistentIdGenerationStrategy.class);
    @NonnullAfterInit
    private PersistentIdStore pidStore;
    @Nullable
    private ComputedPersistentIdGenerationStrategy computedIdStrategy;

    @NonnullAfterInit
    public PersistentIdStore getIDStore() {
        return this.pidStore;
    }

    public void setIDStore(@Nonnull PersistentIdStore store) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.pidStore = (PersistentIdStore)Constraint.isNotNull((Object)store, (String)"PersistentIdStore cannot be null");
    }

    public void setComputedIdStrategy(@Nullable ComputedPersistentIdGenerationStrategy strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.computedIdStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.pidStore) {
            throw new ComponentInitializationException("PersistentIdStore cannot be null");
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generate(@Nonnull @NotEmpty String assertingPartyId, @Nonnull @NotEmpty String relyingPartyId, @Nonnull @NotEmpty String principalName, @Nonnull @NotEmpty String sourceId) throws SAMLException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            this.log.debug("Checking for existing, active, stored ID for principal '{}'", (Object)principalName);
            PersistentIdEntry idEntry = this.pidStore.getActiveEntry(assertingPartyId, relyingPartyId, sourceId);
            if (idEntry == null) {
                this.log.debug("No existing, active, stored ID, creating a new one for principal '{}'", (Object)principalName);
                idEntry = this.createPersistentId(principalName, assertingPartyId, relyingPartyId, sourceId);
                this.pidStore.store(idEntry);
                this.log.debug("Created stored ID '{}'", (Object)idEntry);
            } else {
                this.log.debug("Located existing stored ID {}", (Object)idEntry);
            }
            String pid = StringSupport.trimOrNull((String)idEntry.getPersistentId());
            if (null == pid) {
                this.log.debug("Returned persistent ID was empty");
                throw new SAMLException("Returned persistent ID was empty");
            }
            return pid;
        }
        catch (IOException e) {
            this.log.debug("ID storage error retrieving persistent identifier", (Throwable)e);
            throw new SAMLException("ID storage error retrieving persistent identifier", (Exception)e);
        }
    }

    @Nonnull
    protected PersistentIdEntry createPersistentId(@Nonnull @NotEmpty String principalName, @Nonnull @NotEmpty String localEntityId, @Nonnull @NotEmpty String peerEntityId, @Nonnull @NotEmpty String localId) throws IOException, SAMLException {
        PersistentIdEntry entry = new PersistentIdEntry();
        entry.setIssuerEntityId((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)localEntityId), (String)"Attribute Issuer entity Id must not be null"));
        entry.setRecipientEntityId((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)peerEntityId), (String)"Attribute Recipient entity Id must not be null"));
        entry.setPrincipalName((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)principalName), (String)"Principal must not be null"));
        entry.setSourceId(localId);
        int numberOfExistingEntries = this.pidStore.getCount(entry.getIssuerEntityId(), entry.getRecipientEntityId(), entry.getSourceId());
        String persistentId = numberOfExistingEntries == 0 && null != this.computedIdStrategy ? this.computedIdStrategy.generate(localEntityId, peerEntityId, principalName, localId) : UUID.randomUUID().toString();
        while (!this.pidStore.isAvailable(persistentId)) {
            this.log.debug("Generated persistent ID was already assigned to another user, regenerating");
            persistentId = UUID.randomUUID().toString();
        }
        entry.setPersistentId(persistentId);
        entry.setCreationTime(new Timestamp(System.currentTimeMillis()));
        return entry;
    }
}

