/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;

public class SessionIndexAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public SessionIndexAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject response = (SAMLObject)this.responseLookupStrategy.apply((Object)input);
        if (response != null) {
            if (response instanceof ArtifactResponse) {
                response = ((ArtifactResponse)response).getMessage();
            }
            if (response instanceof Response) {
                for (Assertion assertion : ((Response)response).getAssertions()) {
                    for (AuthnStatement statement : assertion.getAuthnStatements()) {
                        if (statement.getSessionIndex() == null) continue;
                        return statement.getSessionIndex();
                    }
                }
            }
        }
        return null;
    }
}

