/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.attribute.mapping.impl.SAML2AttributesMapperService;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterByQueriedAttributes
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterByQueriedAttributes.class);
    @Nonnull
    private final SAML2AttributesMapperService mapperService;
    @Nonnull
    private Function<ProfileRequestContext, AttributeQuery> queryLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nullable
    private AttributeQuery query;
    @Nullable
    private AttributeContext attributeContext;

    public FilterByQueriedAttributes(@Nonnull SAML2AttributesMapperService mapper) {
        this.mapperService = (SAML2AttributesMapperService)Constraint.isNotNull((Object)mapper, (String)"MapperService cannot be null");
        this.attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
        this.queryLookupStrategy = Functions.compose((Function)new MessageLookup(AttributeQuery.class), (Function)new InboundMessageContextLookup());
    }

    public void setQueryLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeQuery> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.queryLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.query = (AttributeQuery)this.queryLookupStrategy.apply((Object)profileRequestContext);
        if (this.query == null || this.query.getAttributes().isEmpty()) {
            this.log.debug("No queried Attributes found, nothing to do ");
            return false;
        }
        this.attributeContext = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        if (this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ArrayList keepers = Lists.newArrayListWithExpectedSize((int)this.query.getAttributes().size());
        Multimap<String, IdPAttribute> mapped = this.mapperService.mapAttributes(this.query.getAttributes());
        this.log.debug("{} Query content mapped to attribute IDs: {}", (Object)this.getLogPrefix(), (Object)mapped.keySet());
        for (IdPAttribute attribute : this.attributeContext.getIdPAttributes().values()) {
            Collection requested = mapped.get((Object)attribute.getId());
            if (!requested.isEmpty()) {
                this.log.debug("{} Attribute '{}' requested by query, checking for requested values", (Object)this.getLogPrefix(), (Object)attribute.getId());
                int count = this.filterRequestedValues(attribute, requested);
                if (count > 0) {
                    this.log.debug("{} Retaining requested attribute '{}' with {} value(s)", new Object[]{this.getLogPrefix(), attribute.getId(), count});
                    keepers.add(attribute);
                    continue;
                }
                this.log.debug("{} Removing requested attribute '{}', no values left after filtering", (Object)this.getLogPrefix(), (Object)attribute.getId());
                continue;
            }
            this.log.debug("{} Removing attribute '{}' not requested by query", (Object)this.getLogPrefix(), (Object)attribute.getId());
        }
        this.attributeContext.setIdPAttributes((Collection)keepers);
    }

    private int filterRequestedValues(@Nonnull IdPAttribute attribute, @Nonnull @NonnullElements Collection<IdPAttribute> requestedAttributes) {
        boolean requestedValues = false;
        ArrayList keepers = Lists.newArrayListWithExpectedSize((int)attribute.getValues().size());
        for (IdPAttributeValue value : attribute.getValues()) {
            for (IdPAttribute requested : requestedAttributes) {
                if (requested.getValues().isEmpty()) continue;
                requestedValues = true;
                if (!requested.getValues().contains(value)) continue;
                keepers.add(value);
                break;
            }
            if (requestedValues) continue;
            keepers.add(value);
        }
        attribute.setValues((Collection)keepers);
        return keepers.size();
    }
}

