/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizeSAMLSubjectCanonicalization
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FinalizeSAMLSubjectCanonicalization.class);
    @Nullable
    private String canonicalPrincipalName;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SubjectCanonicalizationContext c14nCtx = (SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class);
        if (c14nCtx == null) {
            this.log.debug("{} No SubjectCanonicalizationContext available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubjectCanonicalizationContext");
            return false;
        }
        this.canonicalPrincipalName = c14nCtx.getPrincipalName();
        profileRequestContext.removeSubcontext((BaseContext)c14nCtx);
        if (this.canonicalPrincipalName == null) {
            this.log.debug("{} No principal name in SubjectCanonicalizationContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubjectCanonicalizationContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SubjectContext subjectCtx = new SubjectContext();
        subjectCtx.setPrincipalName(this.canonicalPrincipalName);
        profileRequestContext.addSubcontext((BaseContext)subjectCtx, true);
    }
}

