/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.nameid.TransientIdParameters;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredTransientIdGenerationStrategy
extends AbstractIdentifiableInitializableComponent
implements TransientIdGenerationStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredTransientIdGenerationStrategy.class);
    @NonnullAfterInit
    private StorageService idStore;
    @NonnullAfterInit
    private IdentifierGenerationStrategy idGenerator;
    private int idSize = 16;
    @Duration
    @Positive
    private long idLifetime = 14400000L;

    public void setIdStore(@Nonnull StorageService store) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStore = (StorageService)Constraint.isNotNull((Object)store, (String)"StorageService cannot be null");
    }

    public void setIdGenerator(@Nonnull IdentifierGenerationStrategy generator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"IdentifierGenerationStrategy cannot be null");
    }

    @Positive
    public int getIdSize() {
        return this.idSize;
    }

    public void setIdSize(@Positive int size) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idSize = (int)Constraint.isGreaterThan((long)0L, (long)size, (String)"ID size must be positive");
    }

    @Positive
    public long getIdLifetime() {
        return this.idLifetime;
    }

    public void setIdLifetime(@Duration @Positive long lifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idLifetime = Constraint.isGreaterThan((long)0L, (long)lifetime, (String)"ID lifetime must be positive");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.idStore) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (this.idGenerator == null) {
            this.idGenerator = new RandomIdentifierGenerationStrategy(this.idSize);
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generate(@Nonnull @NotEmpty String relyingPartyId, @Nonnull @NotEmpty String principalName) throws SAMLException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            String principalTokenId = new TransientIdParameters(relyingPartyId, principalName).encode();
            String id = this.idGenerator.generateIdentifier();
            this.log.debug("Creating new transient ID '{}'", (Object)id);
            long expiration = System.currentTimeMillis() + this.idLifetime;
            for (int collisions = 0; collisions < 5; ++collisions) {
                if (!this.idStore.create("TransientId", id, principalTokenId, Long.valueOf(expiration))) continue;
                return id;
            }
            throw new SAMLException("Exceeded allowable number of collisions");
        }
        catch (IOException e) {
            throw new SAMLException((Exception)e);
        }
    }
}

